/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.mongodb.source.reader;

import java.util.Map;
import java.util.function.Supplier;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.connector.base.source.reader.RecordEmitter;
import org.apache.flink.connector.base.source.reader.RecordsWithSplitIds;
import org.apache.flink.connector.base.source.reader.SingleThreadMultiplexSourceReaderBase;
import org.apache.flink.connector.base.source.reader.fetcher.SingleThreadFetcherManager;
import org.apache.flink.connector.base.source.reader.splitreader.SplitReader;
import org.apache.flink.connector.base.source.reader.synchronization.FutureCompletingBlockingQueue;
import org.apache.flink.connector.mongodb.source.reader.MongoSourceReaderContext;
import org.apache.flink.connector.mongodb.source.split.MongoScanSourceSplit;
import org.apache.flink.connector.mongodb.source.split.MongoScanSourceSplitState;
import org.apache.flink.connector.mongodb.source.split.MongoSourceSplit;
import org.apache.flink.connector.mongodb.source.split.MongoSourceSplitState;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class MongoSourceReader<OUT>
extends SingleThreadMultiplexSourceReaderBase<BsonDocument, OUT, MongoSourceSplit, MongoSourceSplitState> {
    private static final Logger LOG = LoggerFactory.getLogger(MongoSourceReader.class);

    public MongoSourceReader(FutureCompletingBlockingQueue<RecordsWithSplitIds<BsonDocument>> elementQueue, Supplier<SplitReader<BsonDocument, MongoSourceSplit>> splitReaderSupplier, RecordEmitter<BsonDocument, OUT, MongoSourceSplitState> recordEmitter, MongoSourceReaderContext readerContext) {
        super(elementQueue, new SingleThreadFetcherManager(elementQueue, splitReaderSupplier), recordEmitter, readerContext.getConfiguration(), (SourceReaderContext)readerContext);
    }

    public void start() {
        if (this.getNumberOfCurrentlyAssignedSplits() == 0) {
            this.context.sendSplitRequest();
        }
    }

    protected void onSplitFinished(Map<String, MongoSourceSplitState> finishedSplitIds) {
        for (MongoSourceSplitState splitState : finishedSplitIds.values()) {
            MongoSourceSplit sourceSplit = splitState.toMongoSourceSplit();
            LOG.info("Split {} is finished.", (Object)sourceSplit.splitId());
        }
        this.context.sendSplitRequest();
    }

    protected MongoSourceSplitState initializedState(MongoSourceSplit split) {
        if (split instanceof MongoScanSourceSplit) {
            return new MongoScanSourceSplitState((MongoScanSourceSplit)split);
        }
        throw new IllegalArgumentException("Unknown split type.");
    }

    protected MongoSourceSplit toSplitType(String splitId, MongoSourceSplitState splitState) {
        return splitState.toMongoSourceSplit();
    }
}

