/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.mongodb.source.enumerator.splitter;

import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.mongodb.source.config.MongoReadOptions;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoNamespace;
import org.apache.flink.mongodb.shaded.com.mongodb.client.MongoClient;
import org.apache.flink.mongodb.shaded.com.mongodb.client.MongoCollection;
import org.apache.flink.mongodb.shaded.org.bson.BsonBoolean;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocument;
import org.apache.flink.mongodb.shaded.org.bson.BsonInt64;

@Internal
public class MongoSplitContext {
    private final MongoReadOptions readOptions;
    private final MongoClient mongoClient;
    private final MongoNamespace namespace;
    private final boolean sharded;
    private final long count;
    private final long size;
    private final long avgObjSize;

    public MongoSplitContext(MongoReadOptions readOptions, MongoClient mongoClient, MongoNamespace namespace, boolean sharded, long count, long size, long avgObjSize) {
        this.readOptions = readOptions;
        this.mongoClient = mongoClient;
        this.namespace = namespace;
        this.sharded = sharded;
        this.count = count;
        this.size = size;
        this.avgObjSize = avgObjSize;
    }

    public static MongoSplitContext of(MongoReadOptions readOptions, MongoClient mongoClient, MongoNamespace namespace, BsonDocument collStats) {
        return new MongoSplitContext(readOptions, mongoClient, namespace, collStats.getBoolean("sharded", BsonBoolean.FALSE).getValue(), collStats.getNumber("count", new BsonInt64(0L)).longValue(), collStats.getNumber("size", new BsonInt64(0L)).longValue(), collStats.getNumber("avgObjSize", new BsonInt64(0L)).longValue());
    }

    public MongoClient getMongoClient() {
        return this.mongoClient;
    }

    public MongoReadOptions getReadOptions() {
        return this.readOptions;
    }

    public String getDatabaseName() {
        return this.namespace.getDatabaseName();
    }

    public String getCollectionName() {
        return this.namespace.getCollectionName();
    }

    public MongoNamespace getMongoNamespace() {
        return this.namespace;
    }

    public MongoCollection<BsonDocument> getMongoCollection() {
        return this.mongoClient.getDatabase(this.namespace.getDatabaseName()).getCollection(this.namespace.getCollectionName()).withDocumentClass(BsonDocument.class);
    }

    public boolean isSharded() {
        return this.sharded;
    }

    public long getCount() {
        return this.count;
    }

    public long getSize() {
        return this.size;
    }

    public long getAvgObjSize() {
        return this.avgObjSize;
    }
}

