/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.mongodb.source;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.SourceReader;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.connector.base.source.reader.RecordsWithSplitIds;
import org.apache.flink.connector.base.source.reader.splitreader.SplitReader;
import org.apache.flink.connector.base.source.reader.synchronization.FutureCompletingBlockingQueue;
import org.apache.flink.connector.mongodb.common.config.MongoConnectionOptions;
import org.apache.flink.connector.mongodb.source.MongoSourceBuilder;
import org.apache.flink.connector.mongodb.source.config.MongoReadOptions;
import org.apache.flink.connector.mongodb.source.enumerator.MongoSourceEnumState;
import org.apache.flink.connector.mongodb.source.enumerator.MongoSourceEnumStateSerializer;
import org.apache.flink.connector.mongodb.source.enumerator.MongoSourceEnumerator;
import org.apache.flink.connector.mongodb.source.enumerator.assigner.MongoScanSplitAssigner;
import org.apache.flink.connector.mongodb.source.reader.MongoSourceReader;
import org.apache.flink.connector.mongodb.source.reader.MongoSourceReaderContext;
import org.apache.flink.connector.mongodb.source.reader.deserializer.MongoDeserializationSchema;
import org.apache.flink.connector.mongodb.source.reader.emitter.MongoRecordEmitter;
import org.apache.flink.connector.mongodb.source.reader.split.MongoScanSourceSplitReader;
import org.apache.flink.connector.mongodb.source.split.MongoSourceSplit;
import org.apache.flink.connector.mongodb.source.split.MongoSourceSplitSerializer;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocument;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class MongoSource<OUT>
implements Source<OUT, MongoSourceSplit, MongoSourceEnumState>,
ResultTypeQueryable<OUT> {
    private static final long serialVersionUID = 1L;
    private final MongoConnectionOptions connectionOptions;
    private final MongoReadOptions readOptions;
    @Nullable
    private final List<String> projectedFields;
    private final int limit;
    private final Boundedness boundedness;
    private final MongoDeserializationSchema<OUT> deserializationSchema;

    MongoSource(MongoConnectionOptions connectionOptions, MongoReadOptions readOptions, @Nullable List<String> projectedFields, int limit, MongoDeserializationSchema<OUT> deserializationSchema) {
        this.connectionOptions = (MongoConnectionOptions)Preconditions.checkNotNull((Object)connectionOptions);
        this.readOptions = (MongoReadOptions)Preconditions.checkNotNull((Object)readOptions);
        this.projectedFields = projectedFields;
        this.limit = limit;
        this.boundedness = Boundedness.BOUNDED;
        this.deserializationSchema = (MongoDeserializationSchema)Preconditions.checkNotNull(deserializationSchema);
    }

    public static <OUT> MongoSourceBuilder<OUT> builder() {
        return new MongoSourceBuilder();
    }

    public Boundedness getBoundedness() {
        return this.boundedness;
    }

    public SourceReader<OUT, MongoSourceSplit> createReader(SourceReaderContext readerContext) {
        FutureCompletingBlockingQueue elementsQueue = new FutureCompletingBlockingQueue();
        MongoSourceReaderContext mongoReaderContext = new MongoSourceReaderContext(readerContext, this.limit);
        Supplier<SplitReader<BsonDocument, MongoSourceSplit>> splitReaderSupplier = () -> new MongoScanSourceSplitReader(this.connectionOptions, this.readOptions, this.projectedFields, mongoReaderContext);
        return new MongoSourceReader((FutureCompletingBlockingQueue<RecordsWithSplitIds<BsonDocument>>)elementsQueue, splitReaderSupplier, new MongoRecordEmitter<OUT>(this.deserializationSchema), mongoReaderContext);
    }

    public SplitEnumerator<MongoSourceSplit, MongoSourceEnumState> createEnumerator(SplitEnumeratorContext<MongoSourceSplit> enumContext) {
        MongoSourceEnumState initialState = MongoSourceEnumState.initialState();
        MongoScanSplitAssigner splitAssigner = new MongoScanSplitAssigner(this.connectionOptions, this.readOptions, initialState);
        return new MongoSourceEnumerator(this.boundedness, enumContext, splitAssigner);
    }

    public SplitEnumerator<MongoSourceSplit, MongoSourceEnumState> restoreEnumerator(SplitEnumeratorContext<MongoSourceSplit> enumContext, MongoSourceEnumState checkpoint) {
        MongoScanSplitAssigner splitAssigner = new MongoScanSplitAssigner(this.connectionOptions, this.readOptions, checkpoint);
        return new MongoSourceEnumerator(this.boundedness, enumContext, splitAssigner);
    }

    public SimpleVersionedSerializer<MongoSourceSplit> getSplitSerializer() {
        return MongoSourceSplitSerializer.INSTANCE;
    }

    public SimpleVersionedSerializer<MongoSourceEnumState> getEnumeratorCheckpointSerializer() {
        return MongoSourceEnumStateSerializer.INSTANCE;
    }

    public TypeInformation<OUT> getProducedType() {
        return this.deserializationSchema.getProducedType();
    }
}

