/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.mongodb.sink;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.base.DeliveryGuarantee;
import org.apache.flink.connector.mongodb.common.config.MongoConnectionOptions;
import org.apache.flink.connector.mongodb.sink.MongoSink;
import org.apache.flink.connector.mongodb.sink.config.MongoWriteOptions;
import org.apache.flink.connector.mongodb.sink.writer.serializer.MongoSerializationSchema;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class MongoSinkBuilder<IN> {
    private final MongoConnectionOptions.MongoConnectionOptionsBuilder connectionOptionsBuilder = MongoConnectionOptions.builder();
    private final MongoWriteOptions.MongoWriteOptionsBuilder writeOptionsBuilder = MongoWriteOptions.builder();
    private MongoSerializationSchema<IN> serializationSchema;

    MongoSinkBuilder() {
    }

    public MongoSinkBuilder<IN> setUri(String uri) {
        this.connectionOptionsBuilder.setUri(uri);
        return this;
    }

    public MongoSinkBuilder<IN> setDatabase(String database) {
        this.connectionOptionsBuilder.setDatabase(database);
        return this;
    }

    public MongoSinkBuilder<IN> setCollection(String collection) {
        this.connectionOptionsBuilder.setCollection(collection);
        return this;
    }

    public MongoSinkBuilder<IN> setBatchSize(int batchSize) {
        this.writeOptionsBuilder.setBatchSize(batchSize);
        return this;
    }

    public MongoSinkBuilder<IN> setBatchIntervalMs(long batchIntervalMs) {
        this.writeOptionsBuilder.setBatchIntervalMs(batchIntervalMs);
        return this;
    }

    public MongoSinkBuilder<IN> setMaxRetries(int maxRetries) {
        this.writeOptionsBuilder.setMaxRetries(maxRetries);
        return this;
    }

    public MongoSinkBuilder<IN> setDeliveryGuarantee(DeliveryGuarantee deliveryGuarantee) {
        this.writeOptionsBuilder.setDeliveryGuarantee(deliveryGuarantee);
        return this;
    }

    public MongoSinkBuilder<IN> setSerializationSchema(MongoSerializationSchema<IN> serializationSchema) {
        Preconditions.checkNotNull(serializationSchema);
        Preconditions.checkState((boolean)InstantiationUtil.isSerializable(serializationSchema), (Object)"The mongo serialization schema must be serializable.");
        this.serializationSchema = serializationSchema;
        return this;
    }

    public MongoSink<IN> build() {
        Preconditions.checkNotNull(this.serializationSchema, (String)"The serialization schema must be supplied");
        return new MongoSink<IN>(this.connectionOptionsBuilder.build(), this.writeOptionsBuilder.build(), this.serializationSchema);
    }
}

