/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.mongodb.common.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.mongodb.shaded.com.mongodb.MongoNamespace;
import org.apache.flink.mongodb.shaded.com.mongodb.client.MongoClient;
import org.apache.flink.mongodb.shaded.com.mongodb.client.MongoCollection;
import org.apache.flink.mongodb.shaded.com.mongodb.client.model.Filters;
import org.apache.flink.mongodb.shaded.com.mongodb.client.model.Projections;
import org.apache.flink.mongodb.shaded.com.mongodb.client.model.Sorts;
import org.apache.flink.mongodb.shaded.org.bson.BsonBoolean;
import org.apache.flink.mongodb.shaded.org.bson.BsonDocument;
import org.apache.flink.mongodb.shaded.org.bson.BsonInt32;
import org.apache.flink.mongodb.shaded.org.bson.BsonString;
import org.apache.flink.mongodb.shaded.org.bson.BsonValue;
import org.apache.flink.mongodb.shaded.org.bson.conversions.Bson;

@Internal
public class MongoUtils {
    private static final String COLL_STATS_COMMAND = "collStats";
    private static final String SPLIT_VECTOR_COMMAND = "splitVector";
    private static final String KEY_PATTERN_OPTION = "keyPattern";
    private static final String MAX_CHUNK_SIZE_OPTION = "maxChunkSize";
    private static final String CONFIG_DATABASE = "config";
    private static final String COLLECTIONS_COLLECTION = "collections";
    private static final String CHUNKS_COLLECTION = "chunks";

    private MongoUtils() {
    }

    public static BsonDocument collStats(MongoClient mongoClient, MongoNamespace namespace) {
        BsonDocument collStatsCommand = new BsonDocument(COLL_STATS_COMMAND, new BsonString(namespace.getCollectionName()));
        return mongoClient.getDatabase(namespace.getDatabaseName()).runCommand((Bson)collStatsCommand, BsonDocument.class);
    }

    public static BsonDocument splitVector(MongoClient mongoClient, MongoNamespace namespace, BsonDocument keyPattern, int maxChunkSizeMB) {
        return MongoUtils.splitVector(mongoClient, namespace, keyPattern, maxChunkSizeMB, null, null);
    }

    public static BsonDocument splitVector(MongoClient mongoClient, MongoNamespace namespace, BsonDocument keyPattern, int maxChunkSizeMB, @Nullable BsonDocument min, @Nullable BsonDocument max) {
        BsonDocument splitVectorCommand = new BsonDocument(SPLIT_VECTOR_COMMAND, new BsonString(namespace.getFullName())).append(KEY_PATTERN_OPTION, keyPattern).append(MAX_CHUNK_SIZE_OPTION, new BsonInt32(maxChunkSizeMB));
        Optional.ofNullable(min).ifPresent(v -> splitVectorCommand.append("min", (BsonValue)v));
        Optional.ofNullable(max).ifPresent(v -> splitVectorCommand.append("max", (BsonValue)v));
        return mongoClient.getDatabase(namespace.getDatabaseName()).runCommand((Bson)splitVectorCommand, BsonDocument.class);
    }

    public static Optional<BsonDocument> readCollectionMetadata(MongoClient mongoClient, MongoNamespace namespace) {
        MongoCollection<BsonDocument> collections = mongoClient.getDatabase(CONFIG_DATABASE).getCollection(COLLECTIONS_COLLECTION).withDocumentClass(BsonDocument.class);
        return Optional.ofNullable(collections.find(Filters.eq("_id", namespace.getFullName())).projection(Projections.include("_id", "uuid", "dropped", "key")).first());
    }

    public static boolean isShardedCollectionDropped(BsonDocument collectionMetadata) {
        return collectionMetadata.getBoolean("dropped", BsonBoolean.FALSE).getValue();
    }

    public static List<BsonDocument> readChunks(MongoClient mongoClient, BsonDocument collectionMetadata) {
        MongoCollection<BsonDocument> chunks = mongoClient.getDatabase(CONFIG_DATABASE).getCollection(CHUNKS_COLLECTION).withDocumentClass(BsonDocument.class);
        Bson filter = Filters.or(new BsonDocument("ns", collectionMetadata.get("_id")), new BsonDocument("uuid", collectionMetadata.get("uuid")));
        return chunks.find(filter).projection(Projections.include("min", "max", "shard")).sort(Sorts.ascending("min")).into(new ArrayList());
    }

    public static Bson project(List<String> projectedFields) {
        if (projectedFields.contains("_id")) {
            return Projections.include(projectedFields);
        }
        return Projections.fields(Projections.include(projectedFields), Projections.excludeId());
    }
}

