/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kinesis.util;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.flink.annotation.Internal;
import org.apache.flink.kinesis.shaded.com.amazonaws.ClientConfiguration;
import org.apache.flink.kinesis.shaded.com.amazonaws.ClientConfigurationFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.auth.AWSCredentials;
import org.apache.flink.kinesis.shaded.com.amazonaws.auth.AWSCredentialsProvider;
import org.apache.flink.kinesis.shaded.com.amazonaws.auth.BasicAWSCredentials;
import org.apache.flink.kinesis.shaded.com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import org.apache.flink.kinesis.shaded.com.amazonaws.auth.EnvironmentVariableCredentialsProvider;
import org.apache.flink.kinesis.shaded.com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import org.apache.flink.kinesis.shaded.com.amazonaws.auth.SystemPropertiesCredentialsProvider;
import org.apache.flink.kinesis.shaded.com.amazonaws.auth.WebIdentityTokenCredentialsProvider;
import org.apache.flink.kinesis.shaded.com.amazonaws.auth.profile.ProfileCredentialsProvider;
import org.apache.flink.kinesis.shaded.com.amazonaws.client.builder.AwsClientBuilder;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.AmazonKinesis;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.AmazonKinesisClientBuilder;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import org.apache.flink.kinesis.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.kinesis.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.kinesis.shaded.com.fasterxml.jackson.databind.deser.BeanDeserializerFactory;
import org.apache.flink.kinesis.shaded.com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import org.apache.flink.kinesis.shaded.com.fasterxml.jackson.databind.deser.DeserializerFactory;
import org.apache.flink.kinesis.shaded.org.apache.flink.connector.aws.config.AWSConfigConstants;
import org.apache.flink.kinesis.shaded.org.apache.flink.connector.aws.util.AWSClientUtil;
import org.apache.flink.streaming.connectors.kinesis.config.AWSConfigConstants;
import org.apache.flink.streaming.connectors.kinesis.model.SentinelSequenceNumber;
import org.apache.flink.streaming.connectors.kinesis.model.SequenceNumber;
import org.apache.flink.streaming.connectors.kinesis.model.StartingPosition;
import org.apache.flink.streaming.connectors.kinesis.util.BeanDeserializerModifierForIgnorables;
import org.apache.flink.streaming.connectors.kinesis.util.KinesisConfigUtil;

@Internal
public class AWSUtil {
    public static final String AWS_CLIENT_CONFIG_PREFIX = "aws.clientconfig.";

    public static AmazonKinesis createKinesisClient(Properties configProps) {
        return AWSUtil.createKinesisClient(configProps, new ClientConfigurationFactory().getConfig());
    }

    public static AmazonKinesis createKinesisClient(Properties configProps, ClientConfiguration awsClientConfig) {
        awsClientConfig.setUserAgentPrefix(AWSClientUtil.formatFlinkUserAgentPrefix("Apache Flink %s (%s) Kinesis Connector"));
        AmazonKinesisClientBuilder builder = (AmazonKinesisClientBuilder)((AmazonKinesisClientBuilder)AmazonKinesisClientBuilder.standard().withCredentials(AWSUtil.getCredentialsProvider(configProps))).withClientConfiguration(awsClientConfig);
        if (configProps.containsKey("aws.endpoint")) {
            builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(configProps.getProperty("aws.endpoint"), configProps.getProperty("aws.region")));
        } else {
            builder.withRegion(configProps.getProperty("aws.region"));
        }
        return (AmazonKinesis)builder.build();
    }

    public static AWSCredentialsProvider getCredentialsProvider(Properties configProps) {
        return AWSUtil.getCredentialsProvider(configProps, "aws.credentials.provider");
    }

    private static AWSCredentialsProvider getCredentialsProvider(final Properties configProps, final String configPrefix) {
        AWSConfigConstants.CredentialProvider credentialProviderType = AWSClientUtil.getCredentialProviderType(configProps, configPrefix);
        switch (credentialProviderType) {
            case ENV_VAR: {
                return new EnvironmentVariableCredentialsProvider();
            }
            case SYS_PROP: {
                return new SystemPropertiesCredentialsProvider();
            }
            case PROFILE: {
                String profileName = configProps.getProperty(AWSConfigConstants.profileName(configPrefix), null);
                String profileConfigPath = configProps.getProperty(AWSConfigConstants.profilePath(configPrefix), null);
                return profileConfigPath == null ? new ProfileCredentialsProvider(profileName) : new ProfileCredentialsProvider(profileConfigPath, profileName);
            }
            case BASIC: {
                return new AWSCredentialsProvider(){

                    @Override
                    public AWSCredentials getCredentials() {
                        return new BasicAWSCredentials(configProps.getProperty(AWSConfigConstants.accessKeyId(configPrefix)), configProps.getProperty(AWSConfigConstants.secretKey(configPrefix)));
                    }

                    @Override
                    public void refresh() {
                    }
                };
            }
            case ASSUME_ROLE: {
                return new STSAssumeRoleSessionCredentialsProvider.Builder(configProps.getProperty(AWSConfigConstants.roleArn(configPrefix)), configProps.getProperty(AWSConfigConstants.roleSessionName(configPrefix))).withExternalId(configProps.getProperty(AWSConfigConstants.externalId(configPrefix))).withStsClient(AWSUtil.createStsClient(configProps, configPrefix)).build();
            }
            case WEB_IDENTITY_TOKEN: {
                return WebIdentityTokenCredentialsProvider.builder().roleArn(configProps.getProperty(AWSConfigConstants.roleArn(configPrefix), null)).roleSessionName(configProps.getProperty(AWSConfigConstants.roleSessionName(configPrefix), null)).webIdentityTokenFile(configProps.getProperty(AWSConfigConstants.webIdentityTokenFile(configPrefix), null)).build();
            }
            case AUTO: {
                return new DefaultAWSCredentialsProviderChain();
            }
        }
        throw new IllegalArgumentException("Credential provider not supported: " + (Object)((Object)credentialProviderType));
    }

    private static AWSSecurityTokenService createStsClient(Properties configProps, String configPrefix) {
        String region = configProps.getProperty("aws.region");
        AWSSecurityTokenServiceClientBuilder stsClientBuilder = (AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withCredentials(AWSUtil.getCredentialsProvider(configProps, AWSConfigConstants.roleCredentialsProvider(configPrefix)));
        if (configProps.containsKey(AWSConfigConstants.AWS_ROLE_STS_ENDPOINT)) {
            AwsClientBuilder.EndpointConfiguration endpointConfiguration = new AwsClientBuilder.EndpointConfiguration(configProps.getProperty(AWSConfigConstants.AWS_ROLE_STS_ENDPOINT), region);
            stsClientBuilder.withEndpointConfiguration(endpointConfiguration);
        } else {
            stsClientBuilder.withRegion(region);
        }
        return (AWSSecurityTokenService)stsClientBuilder.build();
    }

    public static boolean isValidRegion(String region) {
        return Pattern.matches("^[a-z]+-([a-z]+[-]{0,1}[a-z]+-([0-9]|global)|global)$", region);
    }

    public static void setAwsClientConfigProperties(ClientConfiguration config, Properties configProps) {
        HashMap<String, Object> awsConfigProperties = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : configProps.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(AWS_CLIENT_CONFIG_PREFIX)) continue;
            awsConfigProperties.put(key.substring(AWS_CLIENT_CONFIG_PREFIX.length()), entry.getValue());
        }
        String[] ignorableProperties = new String[]{"secureRandom"};
        BeanDeserializerModifierForIgnorables modifier = new BeanDeserializerModifierForIgnorables(ClientConfiguration.class, ignorableProperties);
        DeserializerFactory factory = BeanDeserializerFactory.instance.withDeserializerModifier(modifier);
        ObjectMapper mapper = new ObjectMapper(null, null, new DefaultDeserializationContext.Impl(factory));
        JsonNode propTree = mapper.convertValue(awsConfigProperties, JsonNode.class);
        try {
            mapper.readerForUpdating(config).readValue(propTree);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static StartingPosition getStartingPosition(SequenceNumber sequenceNumber, Properties configProps) {
        if (sequenceNumber.equals(SentinelSequenceNumber.SENTINEL_LATEST_SEQUENCE_NUM.get())) {
            return StartingPosition.fromTimestamp(new Date());
        }
        if (SentinelSequenceNumber.SENTINEL_AT_TIMESTAMP_SEQUENCE_NUM.get().equals(sequenceNumber)) {
            Date timestamp = KinesisConfigUtil.parseStreamTimestampStartingPosition(configProps);
            return StartingPosition.fromTimestamp(timestamp);
        }
        return StartingPosition.restartFromSequenceNumber(sequenceNumber);
    }
}

