/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kinesis.table;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.connectors.kinesis.serialization.KinesisDeserializationSchema;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;

@Internal
public final class RowDataKinesisDeserializationSchema
implements KinesisDeserializationSchema<RowData> {
    private static final long serialVersionUID = 5551095193778230749L;
    private final DeserializationSchema<RowData> physicalDeserializer;
    private final TypeInformation<RowData> producedTypeInfo;
    private final List<Metadata> requestedMetadataFields;

    public RowDataKinesisDeserializationSchema(DeserializationSchema<RowData> physicalDeserializer, TypeInformation<RowData> producedTypeInfo, List<Metadata> requestedMetadataFields) {
        this.physicalDeserializer = (DeserializationSchema)Preconditions.checkNotNull(physicalDeserializer);
        this.producedTypeInfo = (TypeInformation)Preconditions.checkNotNull(producedTypeInfo);
        this.requestedMetadataFields = (List)Preconditions.checkNotNull(requestedMetadataFields);
    }

    @Override
    public void open(DeserializationSchema.InitializationContext context) throws Exception {
        this.physicalDeserializer.open(context);
    }

    @Override
    public RowData deserialize(byte[] recordValue, String partitionKey, String seqNum, long approxArrivalTimestamp, String stream, String shardId) throws IOException {
        RowData physicalRow = (RowData)this.physicalDeserializer.deserialize(recordValue);
        if (physicalRow == null) {
            return null;
        }
        GenericRowData metadataRow = new GenericRowData(this.requestedMetadataFields.size());
        for (int i = 0; i < metadataRow.getArity(); ++i) {
            Metadata metadataField = this.requestedMetadataFields.get(i);
            if (metadataField == Metadata.Timestamp) {
                metadataRow.setField(i, (Object)TimestampData.fromEpochMillis((long)approxArrivalTimestamp));
                continue;
            }
            if (metadataField == Metadata.SequenceNumber) {
                metadataRow.setField(i, (Object)StringData.fromString((String)seqNum));
                continue;
            }
            if (metadataField == Metadata.ShardId) {
                metadataRow.setField(i, (Object)StringData.fromString((String)shardId));
                continue;
            }
            String msg = String.format("Unsupported metadata key %s", new Object[]{metadataField});
            throw new RuntimeException(msg);
        }
        return new JoinedRowData(physicalRow.getRowKind(), physicalRow, (RowData)metadataRow);
    }

    public TypeInformation<RowData> getProducedType() {
        return this.producedTypeInfo;
    }

    protected static enum Metadata {
        Timestamp("timestamp", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3).notNull()),
        SequenceNumber("sequence-number", (DataType)DataTypes.VARCHAR((int)128).notNull()),
        ShardId("shard-id", (DataType)DataTypes.VARCHAR((int)128).notNull());

        private final String fieldName;
        private final DataType dataType;

        private Metadata(String fieldName, DataType dataType) {
            this.fieldName = fieldName;
            this.dataType = dataType;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public DataType getDataType() {
            return this.dataType;
        }

        public static Metadata of(String fieldName) {
            return Arrays.stream(Metadata.values()).filter(m -> Objects.equals(m.fieldName, fieldName)).findFirst().orElseThrow(() -> {
                String msg = "Cannot find Metadata instance for field name '" + fieldName + "'";
                return new IllegalArgumentException(msg);
            });
        }
    }
}

