/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kinesis.table;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.kinesis.table.KinesisConnectorOptions;
import org.apache.flink.streaming.connectors.kinesis.table.KinesisConnectorOptionsUtil;
import org.apache.flink.streaming.connectors.kinesis.table.KinesisDynamicSource;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.DataType;

@Internal
public class KinesisDynamicTableFactory
implements DynamicTableSourceFactory {
    public static final String IDENTIFIER = "kinesis";

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        ReadableConfig tableOptions = helper.getOptions();
        ResolvedCatalogTable catalogTable = context.getCatalogTable();
        DataType physicalDataType = catalogTable.getResolvedSchema().toPhysicalRowDataType();
        KinesisConnectorOptionsUtil optionsUtils = new KinesisConnectorOptionsUtil(catalogTable.getOptions(), tableOptions);
        DecodingFormat decodingFormat = helper.discoverDecodingFormat(DeserializationFormatFactory.class, FactoryUtil.FORMAT);
        helper.validateExcept(optionsUtils.getNonValidatedPrefixes().toArray(new String[0]));
        Properties properties = optionsUtils.getValidatedSourceConfigurations();
        return new KinesisDynamicSource(physicalDataType, (String)tableOptions.get(KinesisConnectorOptions.STREAM), (String)tableOptions.get(KinesisConnectorOptions.SHARD_ASSIGNER), properties, (DecodingFormat<DeserializationSchema<RowData>>)decodingFormat);
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(KinesisConnectorOptions.STREAM);
        options.add(FactoryUtil.FORMAT);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(KinesisConnectorOptions.SINK_PARTITIONER);
        options.add(KinesisConnectorOptions.SINK_PARTITIONER_FIELD_DELIMITER);
        options.add(KinesisConnectorOptions.SHARD_ASSIGNER);
        return options;
    }

    public Set<ConfigOption<?>> forwardOptions() {
        return Stream.of(KinesisConnectorOptions.STREAM, KinesisConnectorOptions.SINK_PARTITIONER, KinesisConnectorOptions.SINK_PARTITIONER_FIELD_DELIMITER, KinesisConnectorOptions.SHARD_ASSIGNER).collect(Collectors.toSet());
    }
}

