/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kinesis.table;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.connectors.kinesis.FlinkKinesisConsumer;
import org.apache.flink.streaming.connectors.kinesis.KinesisShardAssigner;
import org.apache.flink.streaming.connectors.kinesis.serialization.KinesisDeserializationSchema;
import org.apache.flink.streaming.connectors.kinesis.serialization.KinesisDeserializationSchemaWrapper;
import org.apache.flink.streaming.connectors.kinesis.table.KinesisDynamicShardAssignerFactory;
import org.apache.flink.streaming.connectors.kinesis.table.RowDataKinesisDeserializationSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceFunctionProvider;
import org.apache.flink.table.connector.source.abilities.SupportsReadingMetadata;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class KinesisDynamicSource
implements ScanTableSource,
SupportsReadingMetadata {
    private static final Logger LOG = LoggerFactory.getLogger(KinesisDynamicSource.class);
    private static final Map<String, DataType> READABLE_METADATA = new HashMap<String, DataType>(){
        {
            for (RowDataKinesisDeserializationSchema.Metadata metadata : RowDataKinesisDeserializationSchema.Metadata.values()) {
                this.put(metadata.getFieldName(), metadata.getDataType());
            }
        }
    };
    private DataType producedDataType;
    private List<RowDataKinesisDeserializationSchema.Metadata> requestedMetadataFields;
    private final DataType physicalDataType;
    private final DecodingFormat<DeserializationSchema<RowData>> decodingFormat;
    private final String stream;
    private final String shardAssignerIdentifier;
    private final Properties consumerProperties;

    public KinesisDynamicSource(DataType physicalDataType, String stream, String shardAssignerIdentifier, Properties consumerProperties, DecodingFormat<DeserializationSchema<RowData>> decodingFormat) {
        this(physicalDataType, stream, shardAssignerIdentifier, consumerProperties, decodingFormat, physicalDataType, Collections.emptyList());
    }

    public KinesisDynamicSource(DataType physicalDataType, String stream, String shardAssignerIdentifier, Properties consumerProperties, DecodingFormat<DeserializationSchema<RowData>> decodingFormat, DataType producedDataType, List<RowDataKinesisDeserializationSchema.Metadata> requestedMetadataFields) {
        this.physicalDataType = (DataType)Preconditions.checkNotNull((Object)physicalDataType, (String)"Physical data type must not be null.");
        this.stream = (String)Preconditions.checkNotNull((Object)stream, (String)"Stream must not be null.");
        this.shardAssignerIdentifier = (String)Preconditions.checkNotNull((Object)shardAssignerIdentifier, (String)"Shard assigner must not be null.");
        this.consumerProperties = (Properties)Preconditions.checkNotNull((Object)consumerProperties, (String)"Properties for the Flink Kinesis consumer must not be null.");
        this.decodingFormat = (DecodingFormat)Preconditions.checkNotNull(decodingFormat, (String)"Decoding format must not be null.");
        this.producedDataType = (DataType)Preconditions.checkNotNull((Object)producedDataType, (String)"Produced data type must not be null.");
        this.requestedMetadataFields = (List)Preconditions.checkNotNull(requestedMetadataFields, (String)"Requested metadata fields must not be null.");
    }

    public ChangelogMode getChangelogMode() {
        return this.decodingFormat.getChangelogMode();
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext runtimeProviderContext) {
        KinesisDeserializationSchema deserializationSchema = this.requestedMetadataFields.size() > 0 ? new RowDataKinesisDeserializationSchema((DeserializationSchema<RowData>)((DeserializationSchema)this.decodingFormat.createRuntimeDecoder((DynamicTableSource.Context)runtimeProviderContext, this.physicalDataType)), (TypeInformation<RowData>)runtimeProviderContext.createTypeInformation(this.producedDataType), this.requestedMetadataFields) : new KinesisDeserializationSchemaWrapper((DeserializationSchema)this.decodingFormat.createRuntimeDecoder((DynamicTableSource.Context)runtimeProviderContext, this.physicalDataType));
        FlinkKinesisConsumer kinesisConsumer = new FlinkKinesisConsumer(this.stream, deserializationSchema, this.consumerProperties);
        KinesisShardAssigner shardAssigner = this.getShardAssigner(this.shardAssignerIdentifier);
        if (shardAssigner != null) {
            kinesisConsumer.setShardAssigner(shardAssigner);
        } else {
            LOG.warn("Unable to load shard assigner with id: '{}'. Falling back to default shard assigner.", (Object)this.shardAssignerIdentifier);
        }
        return SourceFunctionProvider.of(kinesisConsumer, (boolean)false);
    }

    public DynamicTableSource copy() {
        return new KinesisDynamicSource(this.physicalDataType, this.stream, this.shardAssignerIdentifier, this.consumerProperties, this.decodingFormat, this.producedDataType, this.requestedMetadataFields);
    }

    public String asSummaryString() {
        return "Kinesis";
    }

    public Map<String, DataType> listReadableMetadata() {
        return READABLE_METADATA;
    }

    public void applyReadableMetadata(List<String> metadataKeys, DataType producedDataType) {
        this.requestedMetadataFields = metadataKeys.stream().map(RowDataKinesisDeserializationSchema.Metadata::of).collect(Collectors.toList());
        this.producedDataType = producedDataType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KinesisDynamicSource that = (KinesisDynamicSource)o;
        return Objects.equals(this.producedDataType, that.producedDataType) && Objects.equals(this.requestedMetadataFields, that.requestedMetadataFields) && Objects.equals(this.physicalDataType, that.physicalDataType) && Objects.equals(this.stream, that.stream) && Objects.equals(this.consumerProperties, that.consumerProperties) && Objects.equals(this.decodingFormat, that.decodingFormat);
    }

    public int hashCode() {
        return Objects.hash(this.requestedMetadataFields, this.producedDataType, this.physicalDataType, this.stream, this.consumerProperties, this.decodingFormat);
    }

    private KinesisShardAssigner getShardAssigner(String shardAssignerIdentifier) {
        ServiceLoader<KinesisDynamicShardAssignerFactory> loader = ServiceLoader.load(KinesisDynamicShardAssignerFactory.class);
        Iterator<KinesisDynamicShardAssignerFactory> factories = loader.iterator();
        while (true) {
            try {
                while (factories.hasNext()) {
                    KinesisDynamicShardAssignerFactory factory = factories.next();
                    if (!factory.shardAssignerIdentifer().equals(shardAssignerIdentifier)) continue;
                    return factory.getShardAssigner();
                }
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
                LOG.error("Error while attempting to iterate over shard assigner factories to locate shard assigner with identifier: '{}'", (Object)shardAssignerIdentifier, (Object)serviceConfigurationError);
                continue;
            }
            break;
        }
        LOG.error("Unable to locate shard assigner factory for identifier: '{}'", (Object)shardAssignerIdentifier);
        return null;
    }
}

