/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kinesis.table;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.aws.table.util.AWSOptionUtils;
import org.apache.flink.streaming.connectors.kinesis.util.KinesisConfigUtil;

@PublicEvolving
public class KinesisConsumerOptionsUtil
extends AWSOptionUtils {
    private final Map<String, String> resolvedOptions;
    private final String stream;
    public static final String CONSUMER_PREFIX = "scan.";

    public KinesisConsumerOptionsUtil(Map<String, String> resolvedOptions, String stream) {
        super(resolvedOptions);
        this.resolvedOptions = resolvedOptions;
        this.stream = stream;
    }

    @Override
    public Map<String, String> getProcessedResolvedOptions() {
        Map<String, String> mappedResolvedOptions = super.getProcessedResolvedOptions();
        for (String key : this.resolvedOptions.keySet()) {
            if (!key.startsWith(CONSUMER_PREFIX)) continue;
            mappedResolvedOptions.put(KinesisConsumerOptionsUtil.translateConsumerKey(key), this.resolvedOptions.get(key));
        }
        return mappedResolvedOptions;
    }

    @Override
    public List<String> getNonValidatedPrefixes() {
        return Arrays.asList("aws.", CONSUMER_PREFIX, "sink.");
    }

    @Override
    public Properties getValidatedConfigurations() {
        Properties consumerProperties = super.getValidatedConfigurations();
        consumerProperties.putAll(this.getProcessedResolvedOptions());
        KinesisConfigUtil.validateConsumerConfiguration(consumerProperties, Collections.singletonList(this.stream));
        return consumerProperties;
    }

    private static String translateConsumerKey(String key) {
        String result = "flink." + key.substring(CONSUMER_PREFIX.length());
        if (result.endsWith("initpos-timestamp-format")) {
            return result.replace("initpos-timestamp-format", "initpos.timestamp.format");
        }
        if (result.endsWith("initpos-timestamp")) {
            return result.replace("initpos-timestamp", "initpos.timestamp");
        }
        return result;
    }
}

