/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kinesis.proxy;

import java.util.Collections;
import java.util.Properties;
import org.apache.flink.annotation.Internal;
import org.apache.flink.kinesis.shaded.org.apache.flink.connector.aws.util.AWSClientUtil;
import org.apache.flink.kinesis.shaded.org.apache.flink.connector.aws.util.AWSGeneralUtil;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.SdkHttpClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.SdkHttpConfigurationOption;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.apache.ApacheHttpClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.KinesisClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.AttributeMap;
import org.apache.flink.streaming.connectors.kinesis.internals.publisher.fanout.FanOutRecordPublisherConfiguration;
import org.apache.flink.streaming.connectors.kinesis.proxy.FullJitterBackoff;
import org.apache.flink.streaming.connectors.kinesis.proxy.KinesisProxyAsyncV2;
import org.apache.flink.streaming.connectors.kinesis.proxy.KinesisProxyAsyncV2Interface;
import org.apache.flink.streaming.connectors.kinesis.proxy.KinesisProxySyncV2;
import org.apache.flink.streaming.connectors.kinesis.proxy.KinesisProxySyncV2Interface;
import org.apache.flink.streaming.connectors.kinesis.util.AwsV2Util;
import org.apache.flink.streaming.connectors.kinesis.util.KinesisConfigUtil;
import org.apache.flink.util.Preconditions;

@Internal
public class KinesisProxyV2Factory {
    private static final FullJitterBackoff BACKOFF = new FullJitterBackoff();

    public static KinesisProxyAsyncV2Interface createKinesisProxyAsyncV2(Properties configProps) {
        Preconditions.checkNotNull((Object)configProps);
        AttributeMap convertedProperties = AwsV2Util.convertProperties(configProps);
        AttributeMap.Builder clientConfiguration = AttributeMap.builder();
        KinesisProxyV2Factory.populateDefaultValues(clientConfiguration);
        SdkAsyncHttpClient asyncHttpClient = AWSGeneralUtil.createAsyncHttpClient(convertedProperties.merge(clientConfiguration.build()), NettyNioAsyncHttpClient.builder());
        FanOutRecordPublisherConfiguration configuration = new FanOutRecordPublisherConfiguration(configProps, Collections.emptyList());
        Properties clientProperties = KinesisConfigUtil.getV2ConsumerClientProperties(configProps);
        KinesisAsyncClient asyncClient = (KinesisAsyncClient)AWSClientUtil.createAwsAsyncClient(clientProperties, asyncHttpClient, KinesisAsyncClient.builder(), "Apache Flink %s (%s) Kinesis Connector", "aws.kinesis.client.user-agent-prefix");
        return new KinesisProxyAsyncV2(asyncClient, asyncHttpClient, configuration);
    }

    public static KinesisProxySyncV2Interface createKinesisProxySyncV2(Properties configProps) {
        Preconditions.checkNotNull((Object)configProps);
        AttributeMap convertedProperties = AwsV2Util.convertProperties(configProps);
        AttributeMap.Builder clientConfiguration = AttributeMap.builder();
        KinesisProxyV2Factory.populateDefaultValues(clientConfiguration);
        SdkHttpClient httpClient = AWSGeneralUtil.createSyncHttpClient(convertedProperties.merge(clientConfiguration.build()), ApacheHttpClient.builder());
        FanOutRecordPublisherConfiguration configuration = new FanOutRecordPublisherConfiguration(configProps, Collections.emptyList());
        Properties clientProperties = KinesisConfigUtil.getV2ConsumerClientProperties(configProps);
        KinesisClient client = (KinesisClient)AWSClientUtil.createAwsSyncClient(clientProperties, httpClient, KinesisClient.builder(), "Apache Flink %s (%s) Kinesis Connector", "aws.kinesis.client.user-agent-prefix");
        return new KinesisProxySyncV2(client, httpClient, configuration, BACKOFF);
    }

    private static void populateDefaultValues(AttributeMap.Builder clientConfiguration) {
        clientConfiguration.put(SdkHttpConfigurationOption.TCP_KEEPALIVE, true);
    }
}

