/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kinesis.proxy;

import java.util.concurrent.ExecutionException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.SdkHttpClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.KinesisClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DeregisterStreamConsumerRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DeregisterStreamConsumerResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DescribeStreamConsumerRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DescribeStreamConsumerResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.RegisterStreamConsumerRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.RegisterStreamConsumerResponse;
import org.apache.flink.streaming.connectors.kinesis.internals.publisher.fanout.FanOutRecordPublisherConfiguration;
import org.apache.flink.streaming.connectors.kinesis.proxy.FullJitterBackoff;
import org.apache.flink.streaming.connectors.kinesis.proxy.KinesisProxySyncV2Interface;
import org.apache.flink.streaming.connectors.kinesis.util.AwsV2Util;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class KinesisProxySyncV2
implements KinesisProxySyncV2Interface {
    private static final Logger LOG = LoggerFactory.getLogger(KinesisProxySyncV2.class);
    private final KinesisClient kinesisClient;
    private final SdkHttpClient httpClient;
    private final FanOutRecordPublisherConfiguration fanOutRecordPublisherConfiguration;
    private final FullJitterBackoff backoff;

    public KinesisProxySyncV2(KinesisClient kinesisClient, SdkHttpClient httpClient, FanOutRecordPublisherConfiguration fanOutRecordPublisherConfiguration, FullJitterBackoff backoff) {
        this.kinesisClient = (KinesisClient)Preconditions.checkNotNull((Object)kinesisClient);
        this.httpClient = httpClient;
        this.fanOutRecordPublisherConfiguration = fanOutRecordPublisherConfiguration;
        this.backoff = backoff;
    }

    @Override
    public void close() {
        this.kinesisClient.close();
        this.httpClient.close();
    }

    @Override
    public DescribeStreamSummaryResponse describeStreamSummary(String stream) throws InterruptedException, ExecutionException {
        DescribeStreamSummaryRequest describeStreamRequest = (DescribeStreamSummaryRequest)DescribeStreamSummaryRequest.builder().streamName(stream).build();
        return this.invokeWithRetryAndBackoff(() -> this.kinesisClient.describeStreamSummary(describeStreamRequest), this.fanOutRecordPublisherConfiguration.getDescribeStreamBaseBackoffMillis(), this.fanOutRecordPublisherConfiguration.getDescribeStreamMaxBackoffMillis(), this.fanOutRecordPublisherConfiguration.getDescribeStreamExpConstant(), this.fanOutRecordPublisherConfiguration.getDescribeStreamMaxRetries());
    }

    @Override
    public DescribeStreamConsumerResponse describeStreamConsumer(String streamArn, String consumerName) throws InterruptedException, ExecutionException {
        DescribeStreamConsumerRequest describeStreamConsumerRequest = (DescribeStreamConsumerRequest)DescribeStreamConsumerRequest.builder().streamARN(streamArn).consumerName(consumerName).build();
        return this.describeStreamConsumer(describeStreamConsumerRequest);
    }

    @Override
    public DescribeStreamConsumerResponse describeStreamConsumer(String streamConsumerArn) throws InterruptedException, ExecutionException {
        DescribeStreamConsumerRequest describeStreamConsumerRequest = (DescribeStreamConsumerRequest)DescribeStreamConsumerRequest.builder().consumerARN(streamConsumerArn).build();
        return this.describeStreamConsumer(describeStreamConsumerRequest);
    }

    private DescribeStreamConsumerResponse describeStreamConsumer(DescribeStreamConsumerRequest request) throws InterruptedException, ExecutionException {
        return this.invokeWithRetryAndBackoff(() -> this.kinesisClient.describeStreamConsumer(request), this.fanOutRecordPublisherConfiguration.getDescribeStreamConsumerBaseBackoffMillis(), this.fanOutRecordPublisherConfiguration.getDescribeStreamConsumerMaxBackoffMillis(), this.fanOutRecordPublisherConfiguration.getDescribeStreamConsumerExpConstant(), this.fanOutRecordPublisherConfiguration.getDescribeStreamConsumerMaxRetries());
    }

    @Override
    public RegisterStreamConsumerResponse registerStreamConsumer(String streamArn, String consumerName) throws InterruptedException, ExecutionException {
        RegisterStreamConsumerRequest registerStreamConsumerRequest = (RegisterStreamConsumerRequest)RegisterStreamConsumerRequest.builder().streamARN(streamArn).consumerName(consumerName).build();
        return this.invokeWithRetryAndBackoff(() -> this.kinesisClient.registerStreamConsumer(registerStreamConsumerRequest), this.fanOutRecordPublisherConfiguration.getRegisterStreamBaseBackoffMillis(), this.fanOutRecordPublisherConfiguration.getRegisterStreamMaxBackoffMillis(), this.fanOutRecordPublisherConfiguration.getRegisterStreamExpConstant(), this.fanOutRecordPublisherConfiguration.getRegisterStreamMaxRetries());
    }

    @Override
    public DeregisterStreamConsumerResponse deregisterStreamConsumer(String consumerArn) throws InterruptedException, ExecutionException {
        DeregisterStreamConsumerRequest deregisterStreamConsumerRequest = (DeregisterStreamConsumerRequest)DeregisterStreamConsumerRequest.builder().consumerARN(consumerArn).build();
        return this.invokeWithRetryAndBackoff(() -> this.kinesisClient.deregisterStreamConsumer(deregisterStreamConsumerRequest), this.fanOutRecordPublisherConfiguration.getDeregisterStreamBaseBackoffMillis(), this.fanOutRecordPublisherConfiguration.getDeregisterStreamMaxBackoffMillis(), this.fanOutRecordPublisherConfiguration.getDeregisterStreamExpConstant(), this.fanOutRecordPublisherConfiguration.getDeregisterStreamMaxRetries());
    }

    private <T> T invokeWithRetryAndBackoff(ResponseSupplier<T> responseSupplier, long jitterBase, long jitterMax, double jitterExponent, int maximumNumberOfRetries) throws InterruptedException, ExecutionException {
        T response = null;
        int attempt = 0;
        while (attempt < maximumNumberOfRetries && response == null) {
            try {
                response = responseSupplier.get();
            }
            catch (Exception ex) {
                if (AwsV2Util.isRecoverableException(ex)) {
                    long backoffMillis = this.backoff.calculateFullJitterBackoff(jitterBase, jitterMax, jitterExponent, ++attempt);
                    LOG.warn("Encountered recoverable error: {}. Backing off for {} millis.", new Object[]{ex.getClass().getSimpleName(), backoffMillis, ex});
                    this.backoff.sleep(backoffMillis);
                    continue;
                }
                throw ex;
            }
        }
        if (response == null) {
            throw new RuntimeException("Retries exceeded - all " + maximumNumberOfRetries + " retry attempts failed.");
        }
        return response;
    }

    private static interface ResponseSupplier<T> {
        public T get() throws ExecutionException, InterruptedException;
    }
}

