/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kinesis.proxy;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.annotation.Internal;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.SubscribeToShardRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.SubscribeToShardResponseHandler;
import org.apache.flink.streaming.connectors.kinesis.internals.publisher.fanout.FanOutRecordPublisherConfiguration;
import org.apache.flink.streaming.connectors.kinesis.proxy.KinesisProxyAsyncV2Interface;
import org.apache.flink.util.Preconditions;

@Internal
public class KinesisProxyAsyncV2
implements KinesisProxyAsyncV2Interface {
    private final KinesisAsyncClient kinesisAsyncClient;
    private final SdkAsyncHttpClient asyncHttpClient;
    private final FanOutRecordPublisherConfiguration fanOutRecordPublisherConfiguration;

    public KinesisProxyAsyncV2(KinesisAsyncClient kinesisAsyncClient, SdkAsyncHttpClient asyncHttpClient, FanOutRecordPublisherConfiguration fanOutRecordPublisherConfiguration) {
        this.kinesisAsyncClient = (KinesisAsyncClient)Preconditions.checkNotNull((Object)kinesisAsyncClient);
        this.asyncHttpClient = asyncHttpClient;
        this.fanOutRecordPublisherConfiguration = fanOutRecordPublisherConfiguration;
    }

    @Override
    public CompletableFuture<Void> subscribeToShard(SubscribeToShardRequest request, SubscribeToShardResponseHandler responseHandler) {
        return this.kinesisAsyncClient.subscribeToShard(request, responseHandler);
    }

    @Override
    public void close() {
        this.kinesisAsyncClient.close();
        this.asyncHttpClient.close();
    }
}

