/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kinesis.proxy;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.connectors.kinesis.model.StreamShardHandle;

@Internal
public class GetShardListResult {
    private final Map<String, LinkedList<StreamShardHandle>> streamsToRetrievedShardList = new HashMap<String, LinkedList<StreamShardHandle>>();

    public void addRetrievedShardToStream(String stream, StreamShardHandle retrievedShard) {
        if (!this.streamsToRetrievedShardList.containsKey(stream)) {
            this.streamsToRetrievedShardList.put(stream, new LinkedList());
        }
        this.streamsToRetrievedShardList.get(stream).add(retrievedShard);
    }

    public void addRetrievedShardsToStream(String stream, List<StreamShardHandle> retrievedShards) {
        if (retrievedShards.size() != 0) {
            if (!this.streamsToRetrievedShardList.containsKey(stream)) {
                this.streamsToRetrievedShardList.put(stream, new LinkedList());
            }
            this.streamsToRetrievedShardList.get(stream).addAll(retrievedShards);
        }
    }

    public List<StreamShardHandle> getRetrievedShardListOfStream(String stream) {
        if (!this.streamsToRetrievedShardList.containsKey(stream)) {
            return null;
        }
        return this.streamsToRetrievedShardList.get(stream);
    }

    public StreamShardHandle getLastSeenShardOfStream(String stream) {
        if (!this.streamsToRetrievedShardList.containsKey(stream)) {
            return null;
        }
        return this.streamsToRetrievedShardList.get(stream).getLast();
    }

    public boolean hasRetrievedShards() {
        return !this.streamsToRetrievedShardList.isEmpty();
    }

    public Set<String> getStreamsWithRetrievedShards() {
        return this.streamsToRetrievedShardList.keySet();
    }
}

