/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kinesis.model;

import java.io.Serializable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;

@Internal
public class SequenceNumber
implements Serializable {
    private static final long serialVersionUID = 876972197938972667L;
    private static final String DELIMITER = "-";
    private final String sequenceNumber;
    private final long subSequenceNumber;
    private final int cachedHash;

    public SequenceNumber(String sequenceNumber) {
        this(sequenceNumber, -1L);
    }

    public SequenceNumber(String sequenceNumber, long subSequenceNumber) {
        this.sequenceNumber = (String)Preconditions.checkNotNull((Object)sequenceNumber);
        this.subSequenceNumber = subSequenceNumber;
        this.cachedHash = 37 * (sequenceNumber.hashCode() + Long.valueOf(subSequenceNumber).hashCode());
    }

    public boolean isAggregated() {
        return this.subSequenceNumber >= 0L;
    }

    public String getSequenceNumber() {
        return this.sequenceNumber;
    }

    public long getSubSequenceNumber() {
        return this.subSequenceNumber;
    }

    public String toString() {
        if (this.isAggregated()) {
            return this.sequenceNumber + DELIMITER + this.subSequenceNumber;
        }
        return this.sequenceNumber;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SequenceNumber)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        SequenceNumber other = (SequenceNumber)obj;
        return this.sequenceNumber.equals(other.getSequenceNumber()) && this.subSequenceNumber == other.getSubSequenceNumber();
    }

    public int hashCode() {
        return this.cachedHash;
    }
}

