/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kinesis.internals.publisher.polling;

import java.util.Properties;
import org.apache.flink.annotation.Internal;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.streaming.connectors.kinesis.internals.KinesisDataFetcher;
import org.apache.flink.streaming.connectors.kinesis.internals.publisher.RecordPublisherFactory;
import org.apache.flink.streaming.connectors.kinesis.internals.publisher.polling.AdaptivePollingRecordPublisher;
import org.apache.flink.streaming.connectors.kinesis.internals.publisher.polling.PollingRecordPublisher;
import org.apache.flink.streaming.connectors.kinesis.internals.publisher.polling.PollingRecordPublisherConfiguration;
import org.apache.flink.streaming.connectors.kinesis.metrics.PollingRecordPublisherMetricsReporter;
import org.apache.flink.streaming.connectors.kinesis.model.StartingPosition;
import org.apache.flink.streaming.connectors.kinesis.model.StreamShardHandle;
import org.apache.flink.streaming.connectors.kinesis.proxy.KinesisProxyInterface;
import org.apache.flink.util.Preconditions;

@Internal
public class PollingRecordPublisherFactory
implements RecordPublisherFactory {
    private final KinesisDataFetcher.FlinkKinesisProxyFactory kinesisProxyFactory;

    public PollingRecordPublisherFactory(KinesisDataFetcher.FlinkKinesisProxyFactory kinesisProxyFactory) {
        this.kinesisProxyFactory = kinesisProxyFactory;
    }

    @Override
    public PollingRecordPublisher create(StartingPosition startingPosition, Properties consumerConfig, MetricGroup metricGroup, StreamShardHandle streamShardHandle) throws InterruptedException {
        Preconditions.checkNotNull((Object)startingPosition);
        Preconditions.checkNotNull((Object)consumerConfig);
        Preconditions.checkNotNull((Object)metricGroup);
        Preconditions.checkNotNull((Object)streamShardHandle);
        PollingRecordPublisherConfiguration configuration = new PollingRecordPublisherConfiguration(consumerConfig);
        PollingRecordPublisherMetricsReporter metricsReporter = new PollingRecordPublisherMetricsReporter(metricGroup);
        KinesisProxyInterface kinesisProxy = this.kinesisProxyFactory.create(consumerConfig);
        if (configuration.isAdaptiveReads()) {
            return new AdaptivePollingRecordPublisher(startingPosition, streamShardHandle, metricsReporter, kinesisProxy, configuration.getMaxNumberOfRecordsPerFetch(), configuration.getFetchIntervalMillis());
        }
        return new PollingRecordPublisher(startingPosition, streamShardHandle, metricsReporter, kinesisProxy, configuration.getMaxNumberOfRecordsPerFetch(), configuration.getFetchIntervalMillis());
    }
}

