/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kinesis.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.flink.kinesis.shaded.org.apache.commons.collections.CollectionUtils;
import org.apache.flink.streaming.connectors.kinesis.config.ExceptionConfig;

public class RecoverableErrorsConfig {
    public static final String INVALID_CONFIG_MESSAGE = "Invalid config for recoverable consumer exceptions. Valid config example: `flink.shard.consumer.error.recoverable[0].exception=net.java.UnknownHostException`. Your config array must use zero-based indexing as shown in the example.";
    private final List<ExceptionConfig> exceptionConfigs;

    public static Optional<RecoverableErrorsConfig> createConfigFromPropertiesOrThrow(Properties config) {
        ArrayList<ExceptionConfig> exConfs = new ArrayList<ExceptionConfig>();
        int idx = 0;
        String exceptionConfigKey = String.format("%s[%d].exception", "flink.shard.consumer.error.recoverable", idx);
        while (config.containsKey(exceptionConfigKey)) {
            String exPath = config.getProperty(exceptionConfigKey);
            try {
                Class<?> aClass = Class.forName(exPath);
                if (!Throwable.class.isAssignableFrom(aClass)) {
                    throw new ClassCastException();
                }
                exConfs.add(new ExceptionConfig(aClass));
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Provided recoverable exception class is not a Throwable: " + exPath);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Provided recoverable exception class could not be found: " + exPath);
            }
            exceptionConfigKey = String.format("%s[%d].exception", "flink.shard.consumer.error.recoverable", ++idx);
        }
        if (idx > 0) {
            return Optional.of(new RecoverableErrorsConfig(exConfs));
        }
        for (Object key : config.keySet()) {
            if (!((String)key).startsWith("flink.shard.consumer.error.recoverable")) continue;
            throw new IllegalArgumentException(INVALID_CONFIG_MESSAGE);
        }
        return Optional.empty();
    }

    public RecoverableErrorsConfig(List<ExceptionConfig> exceptionConfigs) {
        this.exceptionConfigs = exceptionConfigs;
    }

    public boolean hasNoConfig() {
        return CollectionUtils.isEmpty(this.exceptionConfigs);
    }

    public List<ExceptionConfig> getExceptionConfigs() {
        return this.exceptionConfigs;
    }
}

