/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.internal;

import java.net.URI;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkProtectedApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.AwsCredentials;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.WebIdentityTokenCredentialsProviderFactory;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.internal.WebIdentityTokenCredentialProperties;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.retry.conditions.OrRetryCondition;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.retry.conditions.RetryCondition;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.Region;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.StsClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.StsClientBuilder;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.auth.StsAssumeRoleWithWebIdentityCredentialsProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.internal.AssumeRoleWithWebIdentityRequestSupplier;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.model.IdpCommunicationErrorException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.IoUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.NumericUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkProtectedApi
public final class StsWebIdentityCredentialsProviderFactory
implements WebIdentityTokenCredentialsProviderFactory {
    @Override
    public AwsCredentialsProvider create(WebIdentityTokenCredentialProperties credentialProperties) {
        return new StsWebIdentityCredentialsProvider(credentialProperties);
    }

    private static final class StsWebIdentityCredentialsProvider
    implements AwsCredentialsProvider,
    SdkAutoCloseable {
        private final StsClient stsClient;
        private final StsAssumeRoleWithWebIdentityCredentialsProvider credentialsProvider;

        private StsWebIdentityCredentialsProvider(WebIdentityTokenCredentialProperties credentialProperties) {
            String roleSessionName = credentialProperties.roleSessionName();
            String sessionName = roleSessionName != null ? roleSessionName : "aws-sdk-java-" + System.currentTimeMillis();
            Boolean asyncCredentialUpdateEnabled = credentialProperties.asyncCredentialUpdateEnabled() != null ? credentialProperties.asyncCredentialUpdateEnabled() : false;
            OrRetryCondition retryCondition = OrRetryCondition.create(context -> context.exception() instanceof IdpCommunicationErrorException, RetryCondition.defaultRetryCondition());
            this.stsClient = (StsClient)((StsClientBuilder)((StsClientBuilder)StsClient.builder().applyMutation(this::configureEndpoint).credentialsProvider(AnonymousCredentialsProvider.create())).overrideConfiguration(o -> o.retryPolicy(r -> r.retryCondition(retryCondition)))).build();
            AssumeRoleWithWebIdentityRequest.Builder requestBuilder = AssumeRoleWithWebIdentityRequest.builder().roleArn(credentialProperties.roleArn()).roleSessionName(sessionName);
            if (credentialProperties.roleSessionDuration() != null) {
                requestBuilder.durationSeconds(NumericUtils.saturatedCast(credentialProperties.roleSessionDuration().getSeconds()));
            }
            AssumeRoleWithWebIdentityRequestSupplier supplier = AssumeRoleWithWebIdentityRequestSupplier.builder().assumeRoleWithWebIdentityRequest((AssumeRoleWithWebIdentityRequest)requestBuilder.build()).webIdentityTokenFile(credentialProperties.webIdentityTokenFile()).build();
            StsAssumeRoleWithWebIdentityCredentialsProvider.Builder builder = ((StsAssumeRoleWithWebIdentityCredentialsProvider.Builder)((StsAssumeRoleWithWebIdentityCredentialsProvider.Builder)StsAssumeRoleWithWebIdentityCredentialsProvider.builder().asyncCredentialUpdateEnabled(asyncCredentialUpdateEnabled)).stsClient(this.stsClient)).refreshRequest(supplier);
            if (credentialProperties.prefetchTime() != null) {
                builder.prefetchTime(credentialProperties.prefetchTime());
            }
            if (credentialProperties.staleTime() != null) {
                builder.staleTime(credentialProperties.staleTime());
            }
            this.credentialsProvider = builder.build();
        }

        @Override
        public AwsCredentials resolveCredentials() {
            return this.credentialsProvider.resolveCredentials();
        }

        @Override
        public void close() {
            IoUtils.closeQuietly(this.credentialsProvider, null);
            IoUtils.closeQuietly(this.stsClient, null);
        }

        private void configureEndpoint(StsClientBuilder stsClientBuilder) {
            Region stsRegion;
            try {
                stsRegion = new DefaultAwsRegionProviderChain().getRegion();
            }
            catch (RuntimeException e) {
                stsRegion = null;
            }
            if (stsRegion != null) {
                stsClientBuilder.region(stsRegion);
            } else {
                stsClientBuilder.region(Region.US_EAST_1);
                stsClientBuilder.endpointOverride(URI.create("https://sts.amazonaws.com"));
            }
        }
    }
}

