/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.endpoints.internal;

import java.util.Optional;
import java.util.concurrent.CompletionException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.AwsExecutionAttribute;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.exception.SdkClientException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.Context;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.endpoints.Endpoint;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.endpoints.StsEndpointParams;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.endpoints.StsEndpointProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.endpoints.internal.AwsEndpointProviderUtils;

@SdkInternalApi
public final class StsResolveEndpointInterceptor
implements ExecutionInterceptor {
    @Override
    public SdkRequest modifyRequest(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        if (AwsEndpointProviderUtils.endpointIsDiscovered(executionAttributes)) {
            return context.request();
        }
        StsEndpointProvider provider = (StsEndpointProvider)executionAttributes.getAttribute(SdkInternalExecutionAttribute.ENDPOINT_PROVIDER);
        try {
            Optional<String> hostPrefix;
            Endpoint result = provider.resolveEndpoint(StsResolveEndpointInterceptor.ruleParams(context, executionAttributes)).join();
            if (!AwsEndpointProviderUtils.disableHostPrefixInjection(executionAttributes) && (hostPrefix = StsResolveEndpointInterceptor.hostPrefix(executionAttributes.getAttribute(SdkExecutionAttribute.OPERATION_NAME), context.request())).isPresent()) {
                result = AwsEndpointProviderUtils.addHostPrefix(result, hostPrefix.get());
            }
            executionAttributes.putAttribute(SdkInternalExecutionAttribute.RESOLVED_ENDPOINT, result);
            return context.request();
        }
        catch (CompletionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SdkClientException) {
                throw (SdkClientException)cause;
            }
            throw SdkClientException.create("Endpoint resolution failed", cause);
        }
    }

    private static StsEndpointParams ruleParams(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        StsEndpointParams.Builder builder = StsEndpointParams.builder();
        builder.region(AwsEndpointProviderUtils.regionBuiltIn(executionAttributes));
        builder.useDualStack(AwsEndpointProviderUtils.dualStackEnabledBuiltIn(executionAttributes));
        builder.useFips(AwsEndpointProviderUtils.fipsEnabledBuiltIn(executionAttributes));
        builder.endpoint(AwsEndpointProviderUtils.endpointBuiltIn(executionAttributes));
        StsResolveEndpointInterceptor.setContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME), context.request());
        StsResolveEndpointInterceptor.setStaticContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME));
        return builder.build();
    }

    private static void setContextParams(StsEndpointParams.Builder params, String operationName, SdkRequest request) {
    }

    private static void setStaticContextParams(StsEndpointParams.Builder params, String operationName) {
    }

    private static Optional<String> hostPrefix(String operationName, SdkRequest request) {
        return Optional.empty();
    }
}

