/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.endpoints.internal;

import java.util.Locale;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.exception.SdkClientException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.jsoncore.JsonNode;

@SdkInternalApi
public enum ParameterType {
    STRING("String"),
    BOOLEAN("Boolean");

    private final String name;

    private ParameterType(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static ParameterType fromNode(JsonNode node) {
        return ParameterType.fromValue(node.asString());
    }

    public static ParameterType fromValue(String value) {
        switch (value.toLowerCase(Locale.ENGLISH)) {
            case "string": {
                return STRING;
            }
            case "boolean": {
                return BOOLEAN;
            }
        }
        throw SdkClientException.create("Unknown parameter type: " + value);
    }
}

