/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.endpoints.internal;

import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.endpoints.internal.Expr;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.endpoints.internal.Fn;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.endpoints.internal.FnNode;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.endpoints.internal.FnVisitor;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.endpoints.internal.Parameter;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.endpoints.internal.RuleError;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.endpoints.internal.Scope;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.endpoints.internal.Value;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.Pair;

@SdkInternalApi
public class BooleanEqualsFn
extends Fn {
    public static final String ID = "booleanEquals";

    public BooleanEqualsFn(FnNode fnNode) {
        super(fnNode);
    }

    @Override
    public <T> T acceptFnVisitor(FnVisitor<T> visitor) {
        return visitor.visitBoolEquals(this);
    }

    public static BooleanEqualsFn ofExprs(Expr left, Expr right) {
        return new BooleanEqualsFn(FnNode.ofExprs(ID, left, right));
    }

    public Expr getLeft() {
        return this.expectTwoArgs().left();
    }

    public Expr getRight() {
        return this.expectTwoArgs().right();
    }

    @Override
    public Value eval(Scope<Value> scope) {
        Pair<Expr, Expr> args = this.expectTwoArgs();
        return RuleError.ctx("while evaluating booleanEquals", () -> Value.fromBool(((Expr)args.left()).eval(scope).expectBool() == ((Expr)args.right()).eval(scope).expectBool()));
    }

    public static BooleanEqualsFn fromParam(Parameter param, Expr value) {
        return BooleanEqualsFn.ofExprs(param.expr(), value);
    }
}

