/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.endpoints.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkProtectedApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.endpoints.authscheme.EndpointAuthScheme;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.endpoints.authscheme.SigV4AuthScheme;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.endpoints.authscheme.SigV4aAuthScheme;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.exception.SdkClientException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.Region;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.RegionScope;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.endpoints.internal.Identifier;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.endpoints.internal.Value;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.Logger;

@SdkProtectedApi
public final class AuthSchemeUtils {
    private static final Logger LOG = Logger.loggerFor(AuthSchemeUtils.class);
    private static final String SIGV4_NAME = "sigv4";
    private static final String SIGV4A_NAME = "sigv4a";
    private static final Set<String> KNOWN_AUTH_SCHEMES;

    private AuthSchemeUtils() {
    }

    public static EndpointAuthScheme chooseAuthScheme(List<EndpointAuthScheme> authSchemes) {
        for (EndpointAuthScheme authScheme : authSchemes) {
            if (!KNOWN_AUTH_SCHEMES.contains(authScheme.name())) continue;
            return authScheme;
        }
        throw SdkClientException.create("Endpoint did not contain any known auth schemes: " + authSchemes);
    }

    public static List<EndpointAuthScheme> createAuthSchemes(Value authSchemesValue) {
        Value.Array schemesArray = authSchemesValue.expectArray();
        ArrayList<EndpointAuthScheme> authSchemes = new ArrayList<EndpointAuthScheme>();
        block8: for (int i = 0; i < schemesArray.size(); ++i) {
            String authSchemeName;
            Value.Record scheme = schemesArray.get(i).expectRecord();
            switch (authSchemeName = scheme.get(Identifier.of("name")).expectString()) {
                case "sigv4a": {
                    Value disableDoubleEncoding;
                    Value signingRegionSet;
                    Object schemeBuilder = SigV4aAuthScheme.builder();
                    Value signingName = scheme.get(Identifier.of("signingName"));
                    if (signingName != null) {
                        ((SigV4aAuthScheme.Builder)schemeBuilder).signingName(signingName.expectString());
                    }
                    if ((signingRegionSet = scheme.get(Identifier.of("signingRegionSet"))) != null) {
                        Value.Array signingRegionSetArray = signingRegionSet.expectArray();
                        for (int j = 0; j < signingRegionSetArray.size(); ++j) {
                            ((SigV4aAuthScheme.Builder)schemeBuilder).addSigningRegion(signingRegionSetArray.get(j).expectString());
                        }
                    }
                    if ((disableDoubleEncoding = scheme.get(Identifier.of("disableDoubleEncoding"))) != null) {
                        ((SigV4aAuthScheme.Builder)schemeBuilder).disableDoubleEncoding(disableDoubleEncoding.expectBool());
                    }
                    authSchemes.add(((SigV4aAuthScheme.Builder)schemeBuilder).build());
                    continue block8;
                }
                case "sigv4": {
                    Value signingRegion;
                    Value disableDoubleEncoding;
                    Object schemeBuilder = SigV4AuthScheme.builder();
                    Value signingName = scheme.get(Identifier.of("signingName"));
                    if (signingName != null) {
                        ((SigV4AuthScheme.Builder)schemeBuilder).signingName(signingName.expectString());
                    }
                    if ((signingRegion = scheme.get(Identifier.of("signingRegion"))) != null) {
                        ((SigV4AuthScheme.Builder)schemeBuilder).signingRegion(signingRegion.expectString());
                    }
                    if ((disableDoubleEncoding = scheme.get(Identifier.of("disableDoubleEncoding"))) != null) {
                        ((SigV4AuthScheme.Builder)schemeBuilder).disableDoubleEncoding(disableDoubleEncoding.expectBool());
                    }
                    authSchemes.add(((SigV4AuthScheme.Builder)schemeBuilder).build());
                    continue block8;
                }
                default: {
                    LOG.debug(() -> "Ignoring unknown auth scheme: " + authSchemeName);
                }
            }
        }
        return authSchemes;
    }

    public static void setSigningParams(ExecutionAttributes executionAttributes, EndpointAuthScheme authScheme) {
        if (authScheme instanceof SigV4AuthScheme) {
            AuthSchemeUtils.setSigV4SigningParams(executionAttributes, (SigV4AuthScheme)authScheme);
        } else if (authScheme instanceof SigV4aAuthScheme) {
            AuthSchemeUtils.setSigV4aAuthSigningParams(executionAttributes, (SigV4aAuthScheme)authScheme);
        } else {
            throw SdkClientException.create("Don't know how to set signing params for auth scheme: " + authScheme.name());
        }
    }

    private static void setSigV4SigningParams(ExecutionAttributes executionAttributes, SigV4AuthScheme sigV4AuthScheme) {
        executionAttributes.putAttribute(AwsSignerExecutionAttribute.SIGNER_DOUBLE_URL_ENCODE, !sigV4AuthScheme.disableDoubleEncoding());
        if (sigV4AuthScheme.signingName() != null) {
            executionAttributes.putAttribute(AwsSignerExecutionAttribute.SERVICE_SIGNING_NAME, sigV4AuthScheme.signingName());
        }
        if (sigV4AuthScheme.signingRegion() != null) {
            executionAttributes.putAttribute(AwsSignerExecutionAttribute.SIGNING_REGION, Region.of(sigV4AuthScheme.signingRegion()));
        }
    }

    private static void setSigV4aAuthSigningParams(ExecutionAttributes executionAttributes, SigV4aAuthScheme sigV4aAuthScheme) {
        executionAttributes.putAttribute(AwsSignerExecutionAttribute.SIGNER_DOUBLE_URL_ENCODE, !sigV4aAuthScheme.disableDoubleEncoding());
        if (sigV4aAuthScheme.signingName() != null) {
            executionAttributes.putAttribute(AwsSignerExecutionAttribute.SERVICE_SIGNING_NAME, sigV4aAuthScheme.signingName());
        }
        if (sigV4aAuthScheme.signingRegionSet() != null) {
            if (sigV4aAuthScheme.signingRegionSet().size() > 1) {
                throw SdkClientException.create("Don't know how to set scope of > 1 region");
            }
            if (sigV4aAuthScheme.signingRegionSet().isEmpty()) {
                throw SdkClientException.create("Signing region set is empty");
            }
            String scope = sigV4aAuthScheme.signingRegionSet().get(0);
            executionAttributes.putAttribute(AwsSignerExecutionAttribute.SIGNING_REGION_SCOPE, RegionScope.create(scope));
        }
    }

    static {
        HashSet<String> schemes = new HashSet<String>();
        schemes.add(SIGV4_NAME);
        schemes.add(SIGV4A_NAME);
        KNOWN_AUTH_SCHEMES = Collections.unmodifiableSet(schemes);
    }
}

