/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.auth;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.NotThreadSafe;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkPublicApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.ThreadSafe;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.StsClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.auth.StsCredentialsProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.internal.StsAuthUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.model.AssumeRoleWithSamlRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.ToString;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.Validate;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
@ThreadSafe
public final class StsAssumeRoleWithSamlCredentialsProvider
extends StsCredentialsProvider
implements ToCopyableBuilder<Builder, StsAssumeRoleWithSamlCredentialsProvider> {
    private final Supplier<AssumeRoleWithSamlRequest> assumeRoleWithSamlRequestSupplier;

    private StsAssumeRoleWithSamlCredentialsProvider(Builder builder) {
        super(builder, "sts-assume-role-with-saml-credentials-provider");
        Validate.notNull(builder.assumeRoleWithSamlRequestSupplier, "Assume role with SAML request must not be null.", new Object[0]);
        this.assumeRoleWithSamlRequestSupplier = builder.assumeRoleWithSamlRequestSupplier;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected AwsSessionCredentials getUpdatedCredentials(StsClient stsClient) {
        AssumeRoleWithSamlRequest assumeRoleWithSamlRequest = this.assumeRoleWithSamlRequestSupplier.get();
        Validate.notNull(assumeRoleWithSamlRequest, "Assume role with saml request must not be null.", new Object[0]);
        return StsAuthUtils.toAwsSessionCredentials(stsClient.assumeRoleWithSAML(assumeRoleWithSamlRequest).credentials());
    }

    public String toString() {
        return ToString.create("StsAssumeRoleWithSamlCredentialsProvider");
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @NotThreadSafe
    public static final class Builder
    extends StsCredentialsProvider.BaseBuilder<Builder, StsAssumeRoleWithSamlCredentialsProvider> {
        private Supplier<AssumeRoleWithSamlRequest> assumeRoleWithSamlRequestSupplier;

        private Builder() {
            super((B x$0) -> new StsAssumeRoleWithSamlCredentialsProvider((Builder)x$0));
        }

        public Builder(StsAssumeRoleWithSamlCredentialsProvider provider) {
            super(x$0 -> new StsAssumeRoleWithSamlCredentialsProvider((Builder)x$0), provider);
            this.assumeRoleWithSamlRequestSupplier = provider.assumeRoleWithSamlRequestSupplier;
        }

        public Builder refreshRequest(AssumeRoleWithSamlRequest assumeRoleWithSamlRequest) {
            return this.refreshRequest(() -> assumeRoleWithSamlRequest);
        }

        public Builder refreshRequest(Supplier<AssumeRoleWithSamlRequest> assumeRoleWithSamlRequestSupplier) {
            this.assumeRoleWithSamlRequestSupplier = assumeRoleWithSamlRequestSupplier;
            return this;
        }

        public Builder refreshRequest(Consumer<AssumeRoleWithSamlRequest.Builder> assumeRoleWithSamlRequest) {
            return this.refreshRequest((AssumeRoleWithSamlRequest)AssumeRoleWithSamlRequest.builder().applyMutation(assumeRoleWithSamlRequest).build());
        }

        @Override
        public StsAssumeRoleWithSamlCredentialsProvider build() {
            return (StsAssumeRoleWithSamlCredentialsProvider)super.build();
        }
    }
}

