/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts;

import java.net.URI;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.client.config.AwsClientOption;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientOption;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.endpoints.EndpointProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.DefaultStsBaseClientBuilder;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.DefaultStsClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.StsClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.StsClientBuilder;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.StsServiceClientConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.endpoints.StsEndpointProvider;

@SdkInternalApi
final class DefaultStsClientBuilder
extends DefaultStsBaseClientBuilder<StsClientBuilder, StsClient>
implements StsClientBuilder {
    DefaultStsClientBuilder() {
    }

    @Override
    public DefaultStsClientBuilder endpointProvider(StsEndpointProvider endpointProvider) {
        this.clientConfiguration.option(SdkClientOption.ENDPOINT_PROVIDER, endpointProvider);
        return this;
    }

    @Override
    protected final StsClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultStsClientBuilder.validateClientOptions(clientConfiguration);
        StsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultStsClient client = new DefaultStsClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private StsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = clientConfig.option(SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option(SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option(SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = clientConfig.option(SdkClientOption.ENDPOINT);
        }
        return StsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region(clientConfig.option(AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

