/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.pagination.sync.SdkIterable;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.KinesisClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.internal.UserAgentUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ListStreamsRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ListStreamsResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.StreamSummary;

public class ListStreamsIterable
implements SdkIterable<ListStreamsResponse> {
    private final KinesisClient client;
    private final ListStreamsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStreamsIterable(KinesisClient client, ListStreamsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListStreamsResponseFetcher();
    }

    @Override
    public Iterator<ListStreamsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> streamNames() {
        Function<ListStreamsResponse, Iterator> getIterator = response -> {
            if (response != null && response.streamNames() != null) {
                return response.streamNames().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    public final SdkIterable<StreamSummary> streamSummaries() {
        Function<ListStreamsResponse, Iterator> getIterator = response -> {
            if (response != null && response.streamSummaries() != null) {
                return response.streamSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    private class ListStreamsResponseFetcher
    implements SyncPageFetcher<ListStreamsResponse> {
        private ListStreamsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListStreamsResponse previousPage) {
            return previousPage.hasMoreStreams();
        }

        @Override
        public ListStreamsResponse nextPage(ListStreamsResponse previousPage) {
            if (previousPage == null) {
                return ListStreamsIterable.this.client.listStreams(ListStreamsIterable.this.firstRequest);
            }
            return ListStreamsIterable.this.client.listStreams((ListStreamsRequest)ListStreamsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

