/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkField;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkPojo;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.protocol.MarshallLocation;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.protocol.MarshallingType;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.traits.LocationTrait;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.ToString;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.builder.CopyableBuilder;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeStreamRequest
extends KinesisRequest
implements ToCopyableBuilder<Builder, DescribeStreamRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("StreamName").getter(DescribeStreamRequest.getter(DescribeStreamRequest::streamName)).setter(DescribeStreamRequest.setter(Builder::streamName)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder(MarshallingType.INTEGER).memberName("Limit").getter(DescribeStreamRequest.getter(DescribeStreamRequest::limit)).setter(DescribeStreamRequest.setter(Builder::limit)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();
    private static final SdkField<String> EXCLUSIVE_START_SHARD_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("ExclusiveStartShardId").getter(DescribeStreamRequest.getter(DescribeStreamRequest::exclusiveStartShardId)).setter(DescribeStreamRequest.setter(Builder::exclusiveStartShardId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusiveStartShardId").build()).build();
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("StreamARN").getter(DescribeStreamRequest.getter(DescribeStreamRequest::streamARN)).setter(DescribeStreamRequest.setter(Builder::streamARN)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD, LIMIT_FIELD, EXCLUSIVE_START_SHARD_ID_FIELD, STREAM_ARN_FIELD));
    private final String streamName;
    private final Integer limit;
    private final String exclusiveStartShardId;
    private final String streamARN;

    private DescribeStreamRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.limit = builder.limit;
        this.exclusiveStartShardId = builder.exclusiveStartShardId;
        this.streamARN = builder.streamARN;
    }

    public final String streamName() {
        return this.streamName;
    }

    public final Integer limit() {
        return this.limit;
    }

    public final String exclusiveStartShardId() {
        return this.exclusiveStartShardId;
    }

    public final String streamARN() {
        return this.streamARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusiveStartShardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamARN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStreamRequest)) {
            return false;
        }
        DescribeStreamRequest other = (DescribeStreamRequest)obj;
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.exclusiveStartShardId(), other.exclusiveStartShardId()) && Objects.equals(this.streamARN(), other.streamARN());
    }

    public final String toString() {
        return ToString.builder("DescribeStreamRequest").add("StreamName", this.streamName()).add("Limit", this.limit()).add("ExclusiveStartShardId", this.exclusiveStartShardId()).add("StreamARN", this.streamARN()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "ExclusiveStartShardId": {
                return Optional.ofNullable(clazz.cast(this.exclusiveStartShardId()));
            }
            case "StreamARN": {
                return Optional.ofNullable(clazz.cast(this.streamARN()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStreamRequest, T> g) {
        return obj -> g.apply((DescribeStreamRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisRequest.BuilderImpl
    implements Builder {
        private String streamName;
        private Integer limit;
        private String exclusiveStartShardId;
        private String streamARN;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStreamRequest model) {
            super(model);
            this.streamName(model.streamName);
            this.limit(model.limit);
            this.exclusiveStartShardId(model.exclusiveStartShardId);
            this.streamARN(model.streamARN);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getExclusiveStartShardId() {
            return this.exclusiveStartShardId;
        }

        public final void setExclusiveStartShardId(String exclusiveStartShardId) {
            this.exclusiveStartShardId = exclusiveStartShardId;
        }

        @Override
        public final Builder exclusiveStartShardId(String exclusiveStartShardId) {
            this.exclusiveStartShardId = exclusiveStartShardId;
            return this;
        }

        public final String getStreamARN() {
            return this.streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeStreamRequest build() {
            return new DescribeStreamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeStreamRequest> {
        public Builder streamName(String var1);

        public Builder limit(Integer var1);

        public Builder exclusiveStartShardId(String var1);

        public Builder streamARN(String var1);

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

