/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.endpoints.internal;

import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.endpoints.internal.Arn;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.endpoints.internal.Expr;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.endpoints.internal.FnNode;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.endpoints.internal.FnVisitor;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.endpoints.internal.Identifier;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.endpoints.internal.SingleArgFn;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.endpoints.internal.Value;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.MapUtils;

@SdkInternalApi
public class ParseArn
extends SingleArgFn {
    public static final String ID = "aws.parseArn";
    public static final Identifier PARTITION = Identifier.of("partition");
    public static final Identifier SERVICE = Identifier.of("service");
    public static final Identifier REGION = Identifier.of("region");
    public static final Identifier ACCOUNT_ID = Identifier.of("accountId");
    private static final Identifier RESOURCE_ID = Identifier.of("resourceId");

    public ParseArn(FnNode fnNode) {
        super(fnNode);
    }

    @Override
    public <T> T acceptFnVisitor(FnVisitor<T> visitor) {
        return visitor.visitParseArn(this);
    }

    public static ParseArn ofExprs(Expr expr) {
        return new ParseArn(FnNode.ofExprs(ID, expr));
    }

    @Override
    protected Value evalArg(Value arg) {
        String value = arg.expectString();
        Optional<Arn> arnOpt = Arn.parse(value);
        return arnOpt.map(arn -> Value.fromRecord(MapUtils.of(PARTITION, Value.fromStr(arn.partition()), SERVICE, Value.fromStr(arn.service()), REGION, Value.fromStr(arn.region()), ACCOUNT_ID, Value.fromStr(arn.accountId()), RESOURCE_ID, Value.fromArray(arn.resource().stream().map(v -> Value.fromStr(v)).collect(Collectors.toList()))))).orElse(new Value.None());
    }
}

