/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.endpoints.internal;

import java.util.Optional;
import java.util.concurrent.CompletionException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.AwsExecutionAttribute;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.exception.SdkClientException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.Context;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.endpoints.Endpoint;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.endpoints.KinesisEndpointParams;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.endpoints.KinesisEndpointProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.endpoints.internal.AwsEndpointProviderUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.AddTagsToStreamRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DecreaseStreamRetentionPeriodRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DeleteStreamRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DeregisterStreamConsumerRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DescribeStreamConsumerRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DescribeStreamRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.DisableEnhancedMonitoringRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.EnableEnhancedMonitoringRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.GetRecordsRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.GetShardIteratorRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.IncreaseStreamRetentionPeriodRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ListShardsRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ListStreamConsumersRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ListTagsForStreamRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.MergeShardsRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.PutRecordRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.PutRecordsRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.RegisterStreamConsumerRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.RemoveTagsFromStreamRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.SplitShardRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.StartStreamEncryptionRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.StopStreamEncryptionRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.SubscribeToShardRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.UpdateShardCountRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.UpdateStreamModeRequest;

@SdkInternalApi
public final class KinesisResolveEndpointInterceptor
implements ExecutionInterceptor {
    @Override
    public SdkRequest modifyRequest(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        if (AwsEndpointProviderUtils.endpointIsDiscovered(executionAttributes)) {
            return context.request();
        }
        KinesisEndpointProvider provider = (KinesisEndpointProvider)executionAttributes.getAttribute(SdkInternalExecutionAttribute.ENDPOINT_PROVIDER);
        try {
            Optional<String> hostPrefix;
            Endpoint result = provider.resolveEndpoint(KinesisResolveEndpointInterceptor.ruleParams(context, executionAttributes)).join();
            if (!AwsEndpointProviderUtils.disableHostPrefixInjection(executionAttributes) && (hostPrefix = KinesisResolveEndpointInterceptor.hostPrefix(executionAttributes.getAttribute(SdkExecutionAttribute.OPERATION_NAME), context.request())).isPresent()) {
                result = AwsEndpointProviderUtils.addHostPrefix(result, hostPrefix.get());
            }
            executionAttributes.putAttribute(SdkInternalExecutionAttribute.RESOLVED_ENDPOINT, result);
            return context.request();
        }
        catch (CompletionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SdkClientException) {
                throw (SdkClientException)cause;
            }
            throw SdkClientException.create("Endpoint resolution failed", cause);
        }
    }

    private static KinesisEndpointParams ruleParams(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        KinesisEndpointParams.Builder builder = KinesisEndpointParams.builder();
        builder.region(AwsEndpointProviderUtils.regionBuiltIn(executionAttributes));
        builder.useDualStack(AwsEndpointProviderUtils.dualStackEnabledBuiltIn(executionAttributes));
        builder.useFips(AwsEndpointProviderUtils.fipsEnabledBuiltIn(executionAttributes));
        builder.endpoint(AwsEndpointProviderUtils.endpointBuiltIn(executionAttributes));
        KinesisResolveEndpointInterceptor.setContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME), context.request());
        KinesisResolveEndpointInterceptor.setStaticContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME));
        return builder.build();
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, String operationName, SdkRequest request) {
        switch (operationName) {
            case "AddTagsToStream": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (AddTagsToStreamRequest)request);
                break;
            }
            case "DecreaseStreamRetentionPeriod": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (DecreaseStreamRetentionPeriodRequest)request);
                break;
            }
            case "DeleteStream": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (DeleteStreamRequest)request);
                break;
            }
            case "DeregisterStreamConsumer": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (DeregisterStreamConsumerRequest)request);
                break;
            }
            case "DescribeStream": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (DescribeStreamRequest)request);
                break;
            }
            case "DescribeStreamConsumer": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (DescribeStreamConsumerRequest)request);
                break;
            }
            case "DescribeStreamSummary": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (DescribeStreamSummaryRequest)request);
                break;
            }
            case "DisableEnhancedMonitoring": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (DisableEnhancedMonitoringRequest)request);
                break;
            }
            case "EnableEnhancedMonitoring": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (EnableEnhancedMonitoringRequest)request);
                break;
            }
            case "GetRecords": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (GetRecordsRequest)request);
                break;
            }
            case "GetShardIterator": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (GetShardIteratorRequest)request);
                break;
            }
            case "IncreaseStreamRetentionPeriod": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (IncreaseStreamRetentionPeriodRequest)request);
                break;
            }
            case "ListShards": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (ListShardsRequest)request);
                break;
            }
            case "ListStreamConsumers": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (ListStreamConsumersRequest)request);
                break;
            }
            case "ListTagsForStream": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (ListTagsForStreamRequest)request);
                break;
            }
            case "MergeShards": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (MergeShardsRequest)request);
                break;
            }
            case "PutRecord": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (PutRecordRequest)request);
                break;
            }
            case "PutRecords": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (PutRecordsRequest)request);
                break;
            }
            case "RegisterStreamConsumer": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (RegisterStreamConsumerRequest)request);
                break;
            }
            case "RemoveTagsFromStream": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (RemoveTagsFromStreamRequest)request);
                break;
            }
            case "SplitShard": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (SplitShardRequest)request);
                break;
            }
            case "StartStreamEncryption": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (StartStreamEncryptionRequest)request);
                break;
            }
            case "StopStreamEncryption": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (StopStreamEncryptionRequest)request);
                break;
            }
            case "SubscribeToShard": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (SubscribeToShardRequest)request);
                break;
            }
            case "UpdateShardCount": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (UpdateShardCountRequest)request);
                break;
            }
            case "UpdateStreamMode": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (UpdateStreamModeRequest)request);
                break;
            }
        }
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, AddTagsToStreamRequest request) {
        params.streamArn(request.streamARN());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, DecreaseStreamRetentionPeriodRequest request) {
        params.streamArn(request.streamARN());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, DeleteStreamRequest request) {
        params.streamArn(request.streamARN());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, DeregisterStreamConsumerRequest request) {
        params.streamArn(request.streamARN());
        params.consumerArn(request.consumerARN());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, DescribeStreamRequest request) {
        params.streamArn(request.streamARN());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, DescribeStreamConsumerRequest request) {
        params.streamArn(request.streamARN());
        params.consumerArn(request.consumerARN());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, DescribeStreamSummaryRequest request) {
        params.streamArn(request.streamARN());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, DisableEnhancedMonitoringRequest request) {
        params.streamArn(request.streamARN());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, EnableEnhancedMonitoringRequest request) {
        params.streamArn(request.streamARN());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, GetRecordsRequest request) {
        params.streamArn(request.streamARN());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, GetShardIteratorRequest request) {
        params.streamArn(request.streamARN());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, IncreaseStreamRetentionPeriodRequest request) {
        params.streamArn(request.streamARN());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, ListShardsRequest request) {
        params.streamArn(request.streamARN());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, ListStreamConsumersRequest request) {
        params.streamArn(request.streamARN());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, ListTagsForStreamRequest request) {
        params.streamArn(request.streamARN());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, MergeShardsRequest request) {
        params.streamArn(request.streamARN());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, PutRecordRequest request) {
        params.streamArn(request.streamARN());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, PutRecordsRequest request) {
        params.streamArn(request.streamARN());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, RegisterStreamConsumerRequest request) {
        params.streamArn(request.streamARN());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, RemoveTagsFromStreamRequest request) {
        params.streamArn(request.streamARN());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, SplitShardRequest request) {
        params.streamArn(request.streamARN());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, StartStreamEncryptionRequest request) {
        params.streamArn(request.streamARN());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, StopStreamEncryptionRequest request) {
        params.streamArn(request.streamARN());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, SubscribeToShardRequest request) {
        params.consumerArn(request.consumerARN());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, UpdateShardCountRequest request) {
        params.streamArn(request.streamARN());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, UpdateStreamModeRequest request) {
        params.streamArn(request.streamARN());
    }

    private static void setStaticContextParams(KinesisEndpointParams.Builder params, String operationName) {
        switch (operationName) {
            case "AddTagsToStream": {
                KinesisResolveEndpointInterceptor.addTagsToStreamStaticContextParams(params);
                break;
            }
            case "DecreaseStreamRetentionPeriod": {
                KinesisResolveEndpointInterceptor.decreaseStreamRetentionPeriodStaticContextParams(params);
                break;
            }
            case "DeleteStream": {
                KinesisResolveEndpointInterceptor.deleteStreamStaticContextParams(params);
                break;
            }
            case "DeregisterStreamConsumer": {
                KinesisResolveEndpointInterceptor.deregisterStreamConsumerStaticContextParams(params);
                break;
            }
            case "DescribeStream": {
                KinesisResolveEndpointInterceptor.describeStreamStaticContextParams(params);
                break;
            }
            case "DescribeStreamConsumer": {
                KinesisResolveEndpointInterceptor.describeStreamConsumerStaticContextParams(params);
                break;
            }
            case "DescribeStreamSummary": {
                KinesisResolveEndpointInterceptor.describeStreamSummaryStaticContextParams(params);
                break;
            }
            case "DisableEnhancedMonitoring": {
                KinesisResolveEndpointInterceptor.disableEnhancedMonitoringStaticContextParams(params);
                break;
            }
            case "EnableEnhancedMonitoring": {
                KinesisResolveEndpointInterceptor.enableEnhancedMonitoringStaticContextParams(params);
                break;
            }
            case "GetRecords": {
                KinesisResolveEndpointInterceptor.getRecordsStaticContextParams(params);
                break;
            }
            case "GetShardIterator": {
                KinesisResolveEndpointInterceptor.getShardIteratorStaticContextParams(params);
                break;
            }
            case "IncreaseStreamRetentionPeriod": {
                KinesisResolveEndpointInterceptor.increaseStreamRetentionPeriodStaticContextParams(params);
                break;
            }
            case "ListShards": {
                KinesisResolveEndpointInterceptor.listShardsStaticContextParams(params);
                break;
            }
            case "ListStreamConsumers": {
                KinesisResolveEndpointInterceptor.listStreamConsumersStaticContextParams(params);
                break;
            }
            case "ListTagsForStream": {
                KinesisResolveEndpointInterceptor.listTagsForStreamStaticContextParams(params);
                break;
            }
            case "MergeShards": {
                KinesisResolveEndpointInterceptor.mergeShardsStaticContextParams(params);
                break;
            }
            case "PutRecord": {
                KinesisResolveEndpointInterceptor.putRecordStaticContextParams(params);
                break;
            }
            case "PutRecords": {
                KinesisResolveEndpointInterceptor.putRecordsStaticContextParams(params);
                break;
            }
            case "RegisterStreamConsumer": {
                KinesisResolveEndpointInterceptor.registerStreamConsumerStaticContextParams(params);
                break;
            }
            case "RemoveTagsFromStream": {
                KinesisResolveEndpointInterceptor.removeTagsFromStreamStaticContextParams(params);
                break;
            }
            case "SplitShard": {
                KinesisResolveEndpointInterceptor.splitShardStaticContextParams(params);
                break;
            }
            case "StartStreamEncryption": {
                KinesisResolveEndpointInterceptor.startStreamEncryptionStaticContextParams(params);
                break;
            }
            case "StopStreamEncryption": {
                KinesisResolveEndpointInterceptor.stopStreamEncryptionStaticContextParams(params);
                break;
            }
            case "SubscribeToShard": {
                KinesisResolveEndpointInterceptor.subscribeToShardStaticContextParams(params);
                break;
            }
            case "UpdateShardCount": {
                KinesisResolveEndpointInterceptor.updateShardCountStaticContextParams(params);
                break;
            }
            case "UpdateStreamMode": {
                KinesisResolveEndpointInterceptor.updateStreamModeStaticContextParams(params);
                break;
            }
        }
    }

    private static void addTagsToStreamStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void decreaseStreamRetentionPeriodStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void deleteStreamStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void deregisterStreamConsumerStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void describeStreamStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void describeStreamConsumerStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void describeStreamSummaryStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void disableEnhancedMonitoringStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void enableEnhancedMonitoringStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void getRecordsStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("data");
    }

    private static void getShardIteratorStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("data");
    }

    private static void increaseStreamRetentionPeriodStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void listShardsStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void listStreamConsumersStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void listTagsForStreamStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void mergeShardsStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void putRecordStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("data");
    }

    private static void putRecordsStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("data");
    }

    private static void registerStreamConsumerStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void removeTagsFromStreamStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void splitShardStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void startStreamEncryptionStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void stopStreamEncryptionStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void subscribeToShardStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("data");
    }

    private static void updateShardCountStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void updateStreamModeStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static Optional<String> hostPrefix(String operationName, SdkRequest request) {
        return Optional.empty();
    }
}

