/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.endpoints.internal;

import java.util.List;
import java.util.function.Supplier;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.signer.Aws4Signer;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.signer.SignerLoader;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.AwsRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.endpoints.authscheme.EndpointAuthScheme;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.util.SignerOverrideUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.exception.SdkClientException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.Context;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.signer.Signer;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.endpoints.Endpoint;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.endpoints.internal.AuthSchemeUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.endpoints.internal.AwsEndpointProviderUtils;

@SdkInternalApi
public final class KinesisEndpointAuthSchemeInterceptor
implements ExecutionInterceptor {
    @Override
    public SdkRequest modifyRequest(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        List<EndpointAuthScheme> authSchemes;
        Endpoint resolvedEndpoint = executionAttributes.getAttribute(SdkInternalExecutionAttribute.RESOLVED_ENDPOINT);
        AwsRequest request = (AwsRequest)context.request();
        if (resolvedEndpoint.headers() != null) {
            request = AwsEndpointProviderUtils.addHeaders(request, resolvedEndpoint.headers());
        }
        if ((authSchemes = resolvedEndpoint.attribute(AwsEndpointAttribute.AUTH_SCHEMES)) == null) {
            return request;
        }
        EndpointAuthScheme chosenAuthScheme = AuthSchemeUtils.chooseAuthScheme(authSchemes);
        Supplier<Signer> signerProvider = this.signerProvider(chosenAuthScheme);
        AuthSchemeUtils.setSigningParams(executionAttributes, chosenAuthScheme);
        return SignerOverrideUtils.overrideSignerIfNotOverridden((SdkRequest)request, executionAttributes, signerProvider);
    }

    private Supplier<Signer> signerProvider(EndpointAuthScheme authScheme) {
        switch (authScheme.name()) {
            case "sigv4": {
                return Aws4Signer::create;
            }
            case "sigv4a": {
                return SignerLoader::getSigV4aSigner;
            }
        }
        throw SdkClientException.create("Don't know how to create signer for auth scheme: " + authScheme.name());
    }
}

