/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.endpoints.internal;

import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.endpoints.internal.Expr;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.endpoints.internal.FnNode;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.endpoints.internal.FnVisitor;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.endpoints.internal.Scope;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.endpoints.internal.Value;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.endpoints.internal.VarargFn;

@SdkInternalApi
public class IsVirtualHostableS3Bucket
extends VarargFn {
    public static final String ID = "aws.isVirtualHostableS3Bucket";

    public IsVirtualHostableS3Bucket(FnNode fnNode) {
        super(fnNode);
    }

    @Override
    public <T> T acceptFnVisitor(FnVisitor<T> visitor) {
        return visitor.visitIsVirtualHostLabelsS3Bucket(this);
    }

    public static IsVirtualHostableS3Bucket ofExprs(Expr expr, boolean allowDots) {
        return new IsVirtualHostableS3Bucket(FnNode.ofExprs(ID, expr, Expr.of(allowDots)));
    }

    public Expr hostLabel() {
        return this.expectTwoArgs().left();
    }

    public Expr allowDots() {
        return this.expectTwoArgs().right();
    }

    @Override
    public Value eval(Scope<Value> scope) {
        String hostLabel = this.expectTwoArgs().left().eval(scope).expectString();
        if (this.allowDots(scope)) {
            return Value.fromBool(hostLabel.matches("[a-z\\d][a-z\\d\\-.]{1,61}[a-z\\d]") && !hostLabel.matches("(\\d+\\.){3}\\d+") && !hostLabel.matches(".*[.-]{2}.*"));
        }
        return Value.fromBool(hostLabel.matches("[a-z\\d][a-z\\d\\-]{1,61}[a-z\\d]"));
    }

    private boolean allowDots(Scope<Value> scope) {
        return this.allowDots().eval(scope).expectBool();
    }
}

