/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis;

import java.net.URI;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.client.config.AwsClientOption;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientOption;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.endpoints.EndpointProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.DefaultKinesisBaseClientBuilder;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.DefaultKinesisClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.KinesisClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.KinesisClientBuilder;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.KinesisServiceClientConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.endpoints.KinesisEndpointProvider;

@SdkInternalApi
final class DefaultKinesisClientBuilder
extends DefaultKinesisBaseClientBuilder<KinesisClientBuilder, KinesisClient>
implements KinesisClientBuilder {
    DefaultKinesisClientBuilder() {
    }

    @Override
    public DefaultKinesisClientBuilder endpointProvider(KinesisEndpointProvider endpointProvider) {
        this.clientConfiguration.option(SdkClientOption.ENDPOINT_PROVIDER, endpointProvider);
        return this;
    }

    @Override
    protected final KinesisClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultKinesisClientBuilder.validateClientOptions(clientConfiguration);
        KinesisServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultKinesisClient client = new DefaultKinesisClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private KinesisServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = clientConfig.option(SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option(SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option(SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = clientConfig.option(SdkClientOption.ENDPOINT);
        }
        return KinesisServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region(clientConfig.option(AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

