/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis;

import java.net.URI;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.client.config.AwsClientOption;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientOption;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.endpoints.EndpointProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.DefaultKinesisAsyncClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.DefaultKinesisBaseClientBuilder;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.KinesisAsyncClientBuilder;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.KinesisServiceClientConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.endpoints.KinesisEndpointProvider;

@SdkInternalApi
final class DefaultKinesisAsyncClientBuilder
extends DefaultKinesisBaseClientBuilder<KinesisAsyncClientBuilder, KinesisAsyncClient>
implements KinesisAsyncClientBuilder {
    DefaultKinesisAsyncClientBuilder() {
    }

    @Override
    public DefaultKinesisAsyncClientBuilder endpointProvider(KinesisEndpointProvider endpointProvider) {
        this.clientConfiguration.option(SdkClientOption.ENDPOINT_PROVIDER, endpointProvider);
        return this;
    }

    @Override
    protected final KinesisAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultKinesisAsyncClientBuilder.validateClientOptions(clientConfiguration);
        KinesisServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultKinesisAsyncClient client = new DefaultKinesisAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private KinesisServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = clientConfig.option(SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option(SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option(SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = clientConfig.option(SdkClientOption.ENDPOINT);
        }
        return KinesisServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region(clientConfig.option(AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

