/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.Optional;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkProtectedApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.exception.SdkClientException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.exception.SdkServiceException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.jsoncore.JsonNode;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.protocols.jsoncore.JsonNodeParser;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.internal.util.ConnectionUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.util.ResourcesEndpointProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.util.ResourcesEndpointRetryParameters;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SdkProtectedApi
public final class HttpResourcesUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpResourcesUtils.class);
    private static final JsonNodeParser JSON_PARSER = JsonNode.parser();
    private static volatile HttpResourcesUtils instance;
    private final ConnectionUtils connectionUtils;

    private HttpResourcesUtils() {
        this(ConnectionUtils.create());
    }

    HttpResourcesUtils(ConnectionUtils connectionUtils) {
        this.connectionUtils = connectionUtils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpResourcesUtils instance() {
        if (instance != null) return instance;
        Class<HttpResourcesUtils> clazz = HttpResourcesUtils.class;
        synchronized (HttpResourcesUtils.class) {
            if (instance != null) return instance;
            instance = new HttpResourcesUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String readResource(URI endpoint) throws IOException {
        return this.readResource(() -> endpoint, "GET");
    }

    public String readResource(ResourcesEndpointProvider endpointProvider) throws IOException {
        return this.readResource(endpointProvider, "GET");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readResource(ResourcesEndpointProvider endpointProvider, String method) throws IOException {
        int retriesAttempted = 0;
        InputStream inputStream = null;
        while (true) {
            block9: {
                int statusCode;
                HttpURLConnection connection;
                block8: {
                    connection = this.connectionUtils.connectToEndpoint(endpointProvider.endpoint(), endpointProvider.headers(), method);
                    statusCode = connection.getResponseCode();
                    if (statusCode != 200) break block8;
                    inputStream = connection.getInputStream();
                    String string = IoUtils.toUtf8String(inputStream);
                    IoUtils.closeQuietly(inputStream, log);
                    return string;
                }
                try {
                    if (statusCode == 404) {
                        throw SdkClientException.builder().message("The requested metadata is not found at " + connection.getURL()).build();
                    }
                    if (endpointProvider.retryPolicy().shouldRetry(retriesAttempted++, ResourcesEndpointRetryParameters.builder().withStatusCode(statusCode).build())) break block9;
                    inputStream = connection.getErrorStream();
                    this.handleErrorResponse(inputStream, statusCode, connection.getResponseMessage());
                }
                catch (IOException ioException) {
                    try {
                        if (!endpointProvider.retryPolicy().shouldRetry(retriesAttempted++, ResourcesEndpointRetryParameters.builder().withException(ioException).build())) {
                            throw ioException;
                        }
                        log.debug("An IOException occurred when connecting to endpoint: {} \n Retrying to connect again", (Object)endpointProvider.endpoint());
                    }
                    catch (Throwable throwable) {
                        IoUtils.closeQuietly(inputStream, log);
                        throw throwable;
                    }
                    IoUtils.closeQuietly(inputStream, log);
                    continue;
                }
            }
            IoUtils.closeQuietly(inputStream, log);
            continue;
            break;
        }
    }

    private void handleErrorResponse(InputStream errorStream, int statusCode, String responseMessage) throws IOException {
        if (errorStream != null) {
            String errorResponse = IoUtils.toUtf8String(errorStream);
            try {
                Optional<JsonNode> message = JSON_PARSER.parse(errorResponse).field("message");
                if (message.isPresent()) {
                    responseMessage = message.get().text();
                }
            }
            catch (RuntimeException exception) {
                log.debug("Unable to parse error stream", (Throwable)exception);
            }
        }
        throw SdkServiceException.builder().message(responseMessage).statusCode(statusCode).build();
    }
}

