/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.servicemetadata;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkPublicApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.EndpointTag;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.PartitionEndpointKey;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.Region;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.ServiceEndpointKey;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.ServiceMetadata;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.ServicePartitionMetadata;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.internal.DefaultServicePartitionMetadata;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.internal.util.ServiceMetadataUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.ImmutableMap;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.Pair;

@SdkPublicApi
public final class ElasticfilesystemServiceMetadata
implements ServiceMetadata {
    private static final String ENDPOINT_PREFIX = "elasticfilesystem";
    private static final List<Region> REGIONS = Collections.unmodifiableList(Arrays.asList(Region.of("af-south-1"), Region.of("ap-east-1"), Region.of("ap-northeast-1"), Region.of("ap-northeast-2"), Region.of("ap-northeast-3"), Region.of("ap-south-1"), Region.of("ap-south-2"), Region.of("ap-southeast-1"), Region.of("ap-southeast-2"), Region.of("ap-southeast-3"), Region.of("ap-southeast-4"), Region.of("ca-central-1"), Region.of("eu-central-1"), Region.of("eu-central-2"), Region.of("eu-north-1"), Region.of("eu-south-1"), Region.of("eu-south-2"), Region.of("eu-west-1"), Region.of("eu-west-2"), Region.of("eu-west-3"), Region.of("fips-af-south-1"), Region.of("fips-ap-east-1"), Region.of("fips-ap-northeast-1"), Region.of("fips-ap-northeast-2"), Region.of("fips-ap-northeast-3"), Region.of("fips-ap-south-1"), Region.of("fips-ap-southeast-1"), Region.of("fips-ap-southeast-2"), Region.of("fips-ca-central-1"), Region.of("fips-eu-central-1"), Region.of("fips-eu-north-1"), Region.of("fips-eu-south-1"), Region.of("fips-eu-west-1"), Region.of("fips-eu-west-2"), Region.of("fips-eu-west-3"), Region.of("fips-me-south-1"), Region.of("fips-sa-east-1"), Region.of("fips-us-east-1"), Region.of("fips-us-east-2"), Region.of("fips-us-west-1"), Region.of("fips-us-west-2"), Region.of("il-central-1"), Region.of("me-central-1"), Region.of("me-south-1"), Region.of("sa-east-1"), Region.of("us-east-1"), Region.of("us-east-2"), Region.of("us-west-1"), Region.of("us-west-2"), Region.of("cn-north-1"), Region.of("cn-northwest-1"), Region.of("fips-cn-north-1"), Region.of("fips-cn-northwest-1"), Region.of("fips-us-gov-east-1"), Region.of("fips-us-gov-west-1"), Region.of("us-gov-east-1"), Region.of("us-gov-west-1"), Region.of("fips-us-iso-east-1"), Region.of("us-iso-east-1"), Region.of("us-iso-west-1"), Region.of("us-isob-east-1")));
    private static final List<ServicePartitionMetadata> PARTITIONS = Collections.unmodifiableList(Arrays.asList(new DefaultServicePartitionMetadata("aws", null), new DefaultServicePartitionMetadata("aws-cn", null), new DefaultServicePartitionMetadata("aws-us-gov", null), new DefaultServicePartitionMetadata("aws-iso", null), new DefaultServicePartitionMetadata("aws-iso-b", null)));
    private static final Map<ServiceEndpointKey, String> SIGNING_REGIONS_BY_REGION = ImmutableMap.builder().put(ServiceEndpointKey.builder().region(Region.of("fips-af-south-1")).build(), "af-south-1").put(ServiceEndpointKey.builder().region(Region.of("fips-ap-east-1")).build(), "ap-east-1").put(ServiceEndpointKey.builder().region(Region.of("fips-ap-northeast-1")).build(), "ap-northeast-1").put(ServiceEndpointKey.builder().region(Region.of("fips-ap-northeast-2")).build(), "ap-northeast-2").put(ServiceEndpointKey.builder().region(Region.of("fips-ap-northeast-3")).build(), "ap-northeast-3").put(ServiceEndpointKey.builder().region(Region.of("fips-ap-south-1")).build(), "ap-south-1").put(ServiceEndpointKey.builder().region(Region.of("fips-ap-southeast-1")).build(), "ap-southeast-1").put(ServiceEndpointKey.builder().region(Region.of("fips-ap-southeast-2")).build(), "ap-southeast-2").put(ServiceEndpointKey.builder().region(Region.of("fips-ca-central-1")).build(), "ca-central-1").put(ServiceEndpointKey.builder().region(Region.of("fips-eu-central-1")).build(), "eu-central-1").put(ServiceEndpointKey.builder().region(Region.of("fips-eu-north-1")).build(), "eu-north-1").put(ServiceEndpointKey.builder().region(Region.of("fips-eu-south-1")).build(), "eu-south-1").put(ServiceEndpointKey.builder().region(Region.of("fips-eu-west-1")).build(), "eu-west-1").put(ServiceEndpointKey.builder().region(Region.of("fips-eu-west-2")).build(), "eu-west-2").put(ServiceEndpointKey.builder().region(Region.of("fips-eu-west-3")).build(), "eu-west-3").put(ServiceEndpointKey.builder().region(Region.of("fips-me-south-1")).build(), "me-south-1").put(ServiceEndpointKey.builder().region(Region.of("fips-sa-east-1")).build(), "sa-east-1").put(ServiceEndpointKey.builder().region(Region.of("fips-us-east-1")).build(), "us-east-1").put(ServiceEndpointKey.builder().region(Region.of("fips-us-east-2")).build(), "us-east-2").put(ServiceEndpointKey.builder().region(Region.of("fips-us-west-1")).build(), "us-west-1").put(ServiceEndpointKey.builder().region(Region.of("fips-us-west-2")).build(), "us-west-2").put(ServiceEndpointKey.builder().region(Region.of("fips-cn-north-1")).build(), "cn-north-1").put(ServiceEndpointKey.builder().region(Region.of("fips-cn-northwest-1")).build(), "cn-northwest-1").put(ServiceEndpointKey.builder().region(Region.of("fips-us-iso-east-1")).build(), "us-iso-east-1").put(ServiceEndpointKey.builder().region(Region.of("fips-us-gov-east-1")).build(), "us-gov-east-1").put(ServiceEndpointKey.builder().region(Region.of("fips-us-gov-west-1")).build(), "us-gov-west-1").build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> SIGNING_REGIONS_BY_PARTITION = ImmutableMap.builder().build();
    private static final Map<ServiceEndpointKey, String> DNS_SUFFIXES_BY_REGION = ImmutableMap.builder().build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> DNS_SUFFIXES_BY_PARTITION = ImmutableMap.builder().build();
    private static final Map<ServiceEndpointKey, String> HOSTNAMES_BY_REGION = ImmutableMap.builder().put(ServiceEndpointKey.builder().region(Region.of("af-south-1")).tags(EndpointTag.of("fips")).build(), "elasticfilesystem-fips.af-south-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ap-east-1")).tags(EndpointTag.of("fips")).build(), "elasticfilesystem-fips.ap-east-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-1")).tags(EndpointTag.of("fips")).build(), "elasticfilesystem-fips.ap-northeast-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-2")).tags(EndpointTag.of("fips")).build(), "elasticfilesystem-fips.ap-northeast-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-3")).tags(EndpointTag.of("fips")).build(), "elasticfilesystem-fips.ap-northeast-3.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ap-south-1")).tags(EndpointTag.of("fips")).build(), "elasticfilesystem-fips.ap-south-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ap-south-2")).tags(EndpointTag.of("fips")).build(), "elasticfilesystem-fips.ap-south-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-1")).tags(EndpointTag.of("fips")).build(), "elasticfilesystem-fips.ap-southeast-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-2")).tags(EndpointTag.of("fips")).build(), "elasticfilesystem-fips.ap-southeast-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-3")).tags(EndpointTag.of("fips")).build(), "elasticfilesystem-fips.ap-southeast-3.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-4")).tags(EndpointTag.of("fips")).build(), "elasticfilesystem-fips.ap-southeast-4.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("ca-central-1")).tags(EndpointTag.of("fips")).build(), "elasticfilesystem-fips.ca-central-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("eu-central-1")).tags(EndpointTag.of("fips")).build(), "elasticfilesystem-fips.eu-central-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("eu-central-2")).tags(EndpointTag.of("fips")).build(), "elasticfilesystem-fips.eu-central-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("eu-north-1")).tags(EndpointTag.of("fips")).build(), "elasticfilesystem-fips.eu-north-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("eu-south-1")).tags(EndpointTag.of("fips")).build(), "elasticfilesystem-fips.eu-south-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("eu-south-2")).tags(EndpointTag.of("fips")).build(), "elasticfilesystem-fips.eu-south-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("eu-west-1")).tags(EndpointTag.of("fips")).build(), "elasticfilesystem-fips.eu-west-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("eu-west-2")).tags(EndpointTag.of("fips")).build(), "elasticfilesystem-fips.eu-west-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("eu-west-3")).tags(EndpointTag.of("fips")).build(), "elasticfilesystem-fips.eu-west-3.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("fips-af-south-1")).build(), "elasticfilesystem-fips.af-south-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("fips-ap-east-1")).build(), "elasticfilesystem-fips.ap-east-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("fips-ap-northeast-1")).build(), "elasticfilesystem-fips.ap-northeast-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("fips-ap-northeast-2")).build(), "elasticfilesystem-fips.ap-northeast-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("fips-ap-northeast-3")).build(), "elasticfilesystem-fips.ap-northeast-3.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("fips-ap-south-1")).build(), "elasticfilesystem-fips.ap-south-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("fips-ap-southeast-1")).build(), "elasticfilesystem-fips.ap-southeast-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("fips-ap-southeast-2")).build(), "elasticfilesystem-fips.ap-southeast-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("fips-ca-central-1")).build(), "elasticfilesystem-fips.ca-central-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("fips-eu-central-1")).build(), "elasticfilesystem-fips.eu-central-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("fips-eu-north-1")).build(), "elasticfilesystem-fips.eu-north-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("fips-eu-south-1")).build(), "elasticfilesystem-fips.eu-south-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("fips-eu-west-1")).build(), "elasticfilesystem-fips.eu-west-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("fips-eu-west-2")).build(), "elasticfilesystem-fips.eu-west-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("fips-eu-west-3")).build(), "elasticfilesystem-fips.eu-west-3.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("fips-me-south-1")).build(), "elasticfilesystem-fips.me-south-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("fips-sa-east-1")).build(), "elasticfilesystem-fips.sa-east-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("fips-us-east-1")).build(), "elasticfilesystem-fips.us-east-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("fips-us-east-2")).build(), "elasticfilesystem-fips.us-east-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("fips-us-west-1")).build(), "elasticfilesystem-fips.us-west-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("fips-us-west-2")).build(), "elasticfilesystem-fips.us-west-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("il-central-1")).tags(EndpointTag.of("fips")).build(), "elasticfilesystem-fips.il-central-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("me-central-1")).tags(EndpointTag.of("fips")).build(), "elasticfilesystem-fips.me-central-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("me-south-1")).tags(EndpointTag.of("fips")).build(), "elasticfilesystem-fips.me-south-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("sa-east-1")).tags(EndpointTag.of("fips")).build(), "elasticfilesystem-fips.sa-east-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-east-1")).tags(EndpointTag.of("fips")).build(), "elasticfilesystem-fips.us-east-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-east-2")).tags(EndpointTag.of("fips")).build(), "elasticfilesystem-fips.us-east-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-west-1")).tags(EndpointTag.of("fips")).build(), "elasticfilesystem-fips.us-west-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-west-2")).tags(EndpointTag.of("fips")).build(), "elasticfilesystem-fips.us-west-2.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("cn-north-1")).tags(EndpointTag.of("fips")).build(), "elasticfilesystem-fips.cn-north-1.amazonaws.com.cn").put(ServiceEndpointKey.builder().region(Region.of("cn-northwest-1")).tags(EndpointTag.of("fips")).build(), "elasticfilesystem-fips.cn-northwest-1.amazonaws.com.cn").put(ServiceEndpointKey.builder().region(Region.of("fips-cn-north-1")).build(), "elasticfilesystem-fips.cn-north-1.amazonaws.com.cn").put(ServiceEndpointKey.builder().region(Region.of("fips-cn-northwest-1")).build(), "elasticfilesystem-fips.cn-northwest-1.amazonaws.com.cn").put(ServiceEndpointKey.builder().region(Region.of("fips-us-iso-east-1")).build(), "elasticfilesystem-fips.us-iso-east-1.c2s.ic.gov").put(ServiceEndpointKey.builder().region(Region.of("us-iso-east-1")).tags(EndpointTag.of("fips")).build(), "elasticfilesystem-fips.us-iso-east-1.c2s.ic.gov").put(ServiceEndpointKey.builder().region(Region.of("us-iso-west-1")).tags(EndpointTag.of("fips")).build(), "elasticfilesystem-fips.us-iso-west-1.c2s.ic.gov").put(ServiceEndpointKey.builder().region(Region.of("us-isob-east-1")).tags(EndpointTag.of("fips")).build(), "elasticfilesystem-fips.us-isob-east-1.sc2s.sgov.gov").put(ServiceEndpointKey.builder().region(Region.of("fips-us-gov-east-1")).build(), "elasticfilesystem-fips.us-gov-east-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("fips-us-gov-west-1")).build(), "elasticfilesystem-fips.us-gov-west-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-gov-east-1")).tags(EndpointTag.of("fips")).build(), "elasticfilesystem-fips.us-gov-east-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("us-gov-west-1")).tags(EndpointTag.of("fips")).build(), "elasticfilesystem-fips.us-gov-west-1.amazonaws.com").build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> HOSTNAMES_BY_PARTITION = ImmutableMap.builder().build();

    @Override
    public List<Region> regions() {
        return REGIONS;
    }

    @Override
    public List<ServicePartitionMetadata> servicePartitions() {
        return PARTITIONS;
    }

    @Override
    public URI endpointFor(ServiceEndpointKey key) {
        return ServiceMetadataUtils.endpointFor(ServiceMetadataUtils.hostname(key, HOSTNAMES_BY_REGION, HOSTNAMES_BY_PARTITION), ENDPOINT_PREFIX, key.region().id(), ServiceMetadataUtils.dnsSuffix(key, DNS_SUFFIXES_BY_REGION, DNS_SUFFIXES_BY_PARTITION));
    }

    @Override
    public Region signingRegion(ServiceEndpointKey key) {
        return ServiceMetadataUtils.signingRegion(key, SIGNING_REGIONS_BY_REGION, SIGNING_REGIONS_BY_PARTITION);
    }
}

