/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.utils;

import java.util.NoSuchElementException;
import java.util.Optional;
import org.apache.flink.kinesis.shaded.io.netty.channel.Channel;
import org.apache.flink.kinesis.shaded.io.netty.channel.ChannelHandler;
import org.apache.flink.kinesis.shaded.io.netty.channel.ChannelPipeline;
import org.apache.flink.kinesis.shaded.io.netty.util.Attribute;
import org.apache.flink.kinesis.shaded.io.netty.util.AttributeKey;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;

@SdkInternalApi
public final class ChannelUtils {
    private ChannelUtils() {
    }

    @SafeVarargs
    public static void removeIfExists(ChannelPipeline pipeline, Class<? extends ChannelHandler> ... handlers) {
        for (Class<? extends ChannelHandler> handler : handlers) {
            if (pipeline.get(handler) == null) continue;
            try {
                pipeline.remove(handler);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    public static <T> Optional<T> getAttribute(Channel channel, AttributeKey<T> key) {
        return Optional.ofNullable(channel.attr(key)).map(Attribute::get);
    }
}

