/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.utils;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.kinesis.shaded.io.netty.channel.Channel;
import org.apache.flink.kinesis.shaded.io.netty.channel.ChannelFactory;
import org.apache.flink.kinesis.shaded.io.netty.channel.EventLoopGroup;
import org.apache.flink.kinesis.shaded.io.netty.channel.ReflectiveChannelFactory;
import org.apache.flink.kinesis.shaded.io.netty.channel.epoll.EpollDatagramChannel;
import org.apache.flink.kinesis.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import org.apache.flink.kinesis.shaded.io.netty.channel.epoll.EpollSocketChannel;
import org.apache.flink.kinesis.shaded.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.flink.kinesis.shaded.io.netty.channel.socket.DatagramChannel;
import org.apache.flink.kinesis.shaded.io.netty.channel.socket.nio.NioDatagramChannel;
import org.apache.flink.kinesis.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.DelegatingEventLoopGroup;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.FunctionalUtils;

@SdkInternalApi
public final class ChannelResolver {
    private static final Map<String, String> KNOWN_EL_GROUPS_SOCKET_CHANNELS = new HashMap<String, String>();
    private static final Map<String, String> KNOWN_EL_GROUPS_DATAGRAM_CHANNELS = new HashMap<String, String>();

    private ChannelResolver() {
    }

    public static ChannelFactory<? extends Channel> resolveSocketChannelFactory(EventLoopGroup eventLoopGroup) {
        if (eventLoopGroup instanceof DelegatingEventLoopGroup) {
            return ChannelResolver.resolveSocketChannelFactory(((DelegatingEventLoopGroup)eventLoopGroup).getDelegate());
        }
        if (eventLoopGroup instanceof NioEventLoopGroup) {
            return NioSocketChannel::new;
        }
        if (eventLoopGroup instanceof EpollEventLoopGroup) {
            return EpollSocketChannel::new;
        }
        String socketFqcn = KNOWN_EL_GROUPS_SOCKET_CHANNELS.get(eventLoopGroup.getClass().getName());
        if (socketFqcn == null) {
            throw new IllegalArgumentException("Unknown event loop group : " + eventLoopGroup.getClass());
        }
        return FunctionalUtils.invokeSafely(() -> new ReflectiveChannelFactory(Class.forName(socketFqcn)));
    }

    public static ChannelFactory<? extends DatagramChannel> resolveDatagramChannelFactory(EventLoopGroup eventLoopGroup) {
        if (eventLoopGroup instanceof DelegatingEventLoopGroup) {
            return ChannelResolver.resolveDatagramChannelFactory(((DelegatingEventLoopGroup)eventLoopGroup).getDelegate());
        }
        if (eventLoopGroup instanceof NioEventLoopGroup) {
            return NioDatagramChannel::new;
        }
        if (eventLoopGroup instanceof EpollEventLoopGroup) {
            return EpollDatagramChannel::new;
        }
        String datagramFqcn = KNOWN_EL_GROUPS_DATAGRAM_CHANNELS.get(eventLoopGroup.getClass().getName());
        if (datagramFqcn == null) {
            throw new IllegalArgumentException("Unknown event loop group : " + eventLoopGroup.getClass());
        }
        return FunctionalUtils.invokeSafely(() -> new ReflectiveChannelFactory(Class.forName(datagramFqcn)));
    }

    static {
        KNOWN_EL_GROUPS_SOCKET_CHANNELS.put("org.apache.flink.kinesis.shaded.io.netty.channel.kqueue.KQueueEventLoopGroup", "org.apache.flink.kinesis.shaded.io.netty.channel.kqueue.KQueueSocketChannel");
        KNOWN_EL_GROUPS_SOCKET_CHANNELS.put("org.apache.flink.kinesis.shaded.io.netty.channel.oio.OioEventLoopGroup", "org.apache.flink.kinesis.shaded.io.netty.channel.socket.oio.OioSocketChannel");
        KNOWN_EL_GROUPS_DATAGRAM_CHANNELS.put("org.apache.flink.kinesis.shaded.io.netty.channel.kqueue.KQueueEventLoopGroup", "org.apache.flink.kinesis.shaded.io.netty.channel.kqueue.KQueueDatagramChannel");
        KNOWN_EL_GROUPS_DATAGRAM_CHANNELS.put("org.apache.flink.kinesis.shaded.io.netty.channel.oio.OioEventLoopGroup", "org.apache.flink.kinesis.shaded.io.netty.channel.socket.oio.OioDatagramChannel");
    }
}

