/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkPublicApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.ProxySystemSetting;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.StringUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.builder.CopyableBuilder;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public final class ProxyConfiguration
implements ToCopyableBuilder<Builder, ProxyConfiguration> {
    private static final String HTTPS = "https";
    private final Boolean useSystemPropertyValues;
    private final String scheme;
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private final Set<String> nonProxyHosts;

    private ProxyConfiguration(BuilderImpl builder) {
        this.useSystemPropertyValues = builder.useSystemPropertyValues;
        this.scheme = builder.scheme;
        this.host = this.resolveHost(builder.host);
        this.port = this.resolvePort(builder.port);
        this.username = builder.username;
        this.password = builder.password;
        this.nonProxyHosts = builder.nonProxyHosts;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public String scheme() {
        return this.scheme;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public String username() {
        if (Objects.equals(this.scheme(), HTTPS)) {
            return this.resolveValue(this.username, ProxySystemSetting.HTTPS_PROXY_USERNAME);
        }
        return this.resolveValue(this.username, ProxySystemSetting.PROXY_USERNAME);
    }

    public String password() {
        if (Objects.equals(this.scheme(), HTTPS)) {
            return this.resolveValue(this.password, ProxySystemSetting.HTTPS_PROXY_PASSWORD);
        }
        return this.resolveValue(this.password, ProxySystemSetting.PROXY_PASSWORD);
    }

    public Set<String> nonProxyHosts() {
        Set<String> hosts = this.nonProxyHosts == null && this.useSystemPropertyValues != false ? this.parseNonProxyHostsProperty() : this.nonProxyHosts;
        return Collections.unmodifiableSet(hosts != null ? hosts : Collections.emptySet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProxyConfiguration that = (ProxyConfiguration)o;
        if (this.port != that.port) {
            return false;
        }
        if (this.scheme != null ? !this.scheme.equals(that.scheme) : that.scheme != null) {
            return false;
        }
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (this.username != null ? !this.username.equals(that.username) : that.username != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        return this.nonProxyHosts.equals(that.nonProxyHosts);
    }

    public int hashCode() {
        int result = this.scheme != null ? this.scheme.hashCode() : 0;
        result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
        result = 31 * result + this.port;
        result = 31 * result + this.nonProxyHosts.hashCode();
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    private String resolveHost(String host) {
        if (Objects.equals(this.scheme(), HTTPS)) {
            return this.resolveValue(host, ProxySystemSetting.HTTPS_PROXY_HOST);
        }
        return this.resolveValue(host, ProxySystemSetting.PROXY_HOST);
    }

    private int resolvePort(int port) {
        if (port == 0 && Boolean.TRUE.equals(this.useSystemPropertyValues)) {
            if (Objects.equals(this.scheme(), HTTPS)) {
                return ProxySystemSetting.HTTPS_PROXY_PORT.getStringValue().map(Integer::parseInt).orElse(0);
            }
            return ProxySystemSetting.PROXY_PORT.getStringValue().map(Integer::parseInt).orElse(0);
        }
        return port;
    }

    private String resolveValue(String value, ProxySystemSetting systemSetting) {
        return value == null && Boolean.TRUE.equals(this.useSystemPropertyValues) ? (String)systemSetting.getStringValue().orElse(null) : value;
    }

    private Set<String> parseNonProxyHostsProperty() {
        String nonProxyHostsSystem = ProxySystemSetting.NON_PROXY_HOSTS.getStringValue().orElse(null);
        if (nonProxyHostsSystem != null && !nonProxyHostsSystem.isEmpty()) {
            return Arrays.stream(nonProxyHostsSystem.split("\\|")).map(String::toLowerCase).map(s -> StringUtils.replace(s, "*", ".*?")).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private static final class BuilderImpl
    implements Builder {
        private String scheme;
        private String host;
        private int port = 0;
        private String username;
        private String password;
        private Set<String> nonProxyHosts;
        private Boolean useSystemPropertyValues = Boolean.TRUE;

        private BuilderImpl() {
        }

        private BuilderImpl(ProxyConfiguration proxyConfiguration) {
            this.useSystemPropertyValues = proxyConfiguration.useSystemPropertyValues;
            this.scheme = proxyConfiguration.scheme;
            this.host = proxyConfiguration.host;
            this.port = proxyConfiguration.port;
            this.nonProxyHosts = proxyConfiguration.nonProxyHosts != null ? new HashSet(proxyConfiguration.nonProxyHosts) : null;
            this.username = proxyConfiguration.username;
            this.password = proxyConfiguration.password;
        }

        @Override
        public Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        @Override
        public Builder host(String host) {
            this.host = host;
            return this;
        }

        @Override
        public Builder port(int port) {
            this.port = port;
            return this;
        }

        @Override
        public Builder nonProxyHosts(Set<String> nonProxyHosts) {
            this.nonProxyHosts = nonProxyHosts != null ? new HashSet<String>(nonProxyHosts) : Collections.emptySet();
            return this;
        }

        @Override
        public Builder username(String username) {
            this.username = username;
            return this;
        }

        @Override
        public Builder password(String password) {
            this.password = password;
            return this;
        }

        @Override
        public Builder useSystemPropertyValues(Boolean useSystemPropertyValues) {
            this.useSystemPropertyValues = useSystemPropertyValues;
            return this;
        }

        public void setUseSystemPropertyValues(Boolean useSystemPropertyValues) {
            this.useSystemPropertyValues(useSystemPropertyValues);
        }

        @Override
        public ProxyConfiguration build() {
            return new ProxyConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProxyConfiguration> {
        public Builder host(String var1);

        public Builder port(int var1);

        public Builder scheme(String var1);

        public Builder nonProxyHosts(Set<String> var1);

        public Builder username(String var1);

        public Builder password(String var1);

        public Builder useSystemPropertyValues(Boolean var1);
    }
}

