/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.util;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.checksums.Algorithm;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.checksums.ChecksumSpecs;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.trait.HttpChecksum;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.util.HttpChecksumUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.StringUtils;

@SdkInternalApi
public final class HttpChecksumResolver {
    private HttpChecksumResolver() {
    }

    public static ChecksumSpecs getResolvedChecksumSpecs(ExecutionAttributes executionAttributes) {
        return Optional.ofNullable(executionAttributes.getAttribute(SdkExecutionAttribute.RESOLVED_CHECKSUM_SPECS)).orElseGet(() -> HttpChecksumResolver.resolveChecksumSpecs(executionAttributes));
    }

    public static ChecksumSpecs resolveChecksumSpecs(ExecutionAttributes executionAttributes) {
        HttpChecksum httpChecksumTraitInOperation = executionAttributes.getAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM);
        if (httpChecksumTraitInOperation == null) {
            return null;
        }
        boolean hasRequestValidation = HttpChecksumResolver.hasRequestValidationMode(httpChecksumTraitInOperation);
        String checksumHeaderName = httpChecksumTraitInOperation.requestAlgorithm() != null ? HttpChecksumUtils.httpChecksumHeader(httpChecksumTraitInOperation.requestAlgorithm()) : null;
        List<Algorithm> responseValidationAlgorithms = HttpChecksumResolver.getResponseValidationAlgorithms(httpChecksumTraitInOperation);
        return ChecksumSpecs.builder().algorithm(Algorithm.fromValue(httpChecksumTraitInOperation.requestAlgorithm())).headerName(checksumHeaderName).responseValidationAlgorithms(responseValidationAlgorithms).isValidationEnabled(hasRequestValidation).isRequestChecksumRequired(httpChecksumTraitInOperation.isRequestChecksumRequired()).isRequestStreaming(httpChecksumTraitInOperation.isRequestStreaming()).build();
    }

    private static boolean hasRequestValidationMode(HttpChecksum httpChecksum) {
        return httpChecksum.requestValidationMode() != null;
    }

    private static List<Algorithm> getResponseValidationAlgorithms(HttpChecksum httpChecksumTraitInOperation) {
        List responseValidationAlgorithms = null;
        if (httpChecksumTraitInOperation.responseAlgorithms() != null && !httpChecksumTraitInOperation.responseAlgorithms().isEmpty()) {
            responseValidationAlgorithms = httpChecksumTraitInOperation.responseAlgorithms().stream().filter(StringUtils::isNotBlank).map(StringUtils::trim).map(Algorithm::fromValue).collect(Collectors.toList());
        }
        return responseValidationAlgorithms;
    }
}

