/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.internal.authcontext;

import java.time.Duration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.AwsCredentials;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.internal.authcontext.AuthorizationStrategy;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.RequestOverrideConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.util.MetricUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.metrics.CoreMetric;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.signer.Signer;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.metrics.MetricCollector;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.Pair;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class AwsCredentialsAuthorizationStrategy
implements AuthorizationStrategy {
    private final SdkRequest request;
    private final Signer defaultSigner;
    private final AwsCredentialsProvider defaultCredentialsProvider;
    private final MetricCollector metricCollector;

    public AwsCredentialsAuthorizationStrategy(Builder builder) {
        this.request = builder.request();
        this.defaultSigner = builder.defaultSigner();
        this.defaultCredentialsProvider = builder.defaultCredentialsProvider();
        this.metricCollector = builder.metricCollector();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Signer resolveSigner() {
        return this.request.overrideConfiguration().flatMap(RequestOverrideConfiguration::signer).orElse(this.defaultSigner);
    }

    @Override
    public void addCredentialsToExecutionAttributes(ExecutionAttributes executionAttributes) {
        AwsCredentialsProvider credentialsProvider = AwsCredentialsAuthorizationStrategy.resolveCredentialsProvider(this.request, this.defaultCredentialsProvider);
        AwsCredentials credentials = AwsCredentialsAuthorizationStrategy.resolveCredentials(credentialsProvider, this.metricCollector);
        executionAttributes.putAttribute(AwsSignerExecutionAttribute.AWS_CREDENTIALS, credentials);
    }

    private static AwsCredentialsProvider resolveCredentialsProvider(SdkRequest originalRequest, AwsCredentialsProvider defaultProvider) {
        return originalRequest.overrideConfiguration().filter(c -> c instanceof AwsRequestOverrideConfiguration).map(c -> (AwsRequestOverrideConfiguration)c).flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElse(defaultProvider);
    }

    private static AwsCredentials resolveCredentials(AwsCredentialsProvider credentialsProvider, MetricCollector metricCollector) {
        Validate.notNull(credentialsProvider, "No credentials provider exists to resolve credentials from.", new Object[0]);
        Pair<AwsCredentials, Duration> measured = MetricUtils.measureDuration(credentialsProvider::resolveCredentials);
        metricCollector.reportMetric(CoreMetric.CREDENTIALS_FETCH_DURATION, measured.right());
        AwsCredentials credentials = measured.left();
        Validate.validState(credentials != null, "Credential providers must never return null.", new Object[0]);
        return credentials;
    }

    public static final class Builder {
        private SdkRequest request;
        private Signer defaultSigner;
        private AwsCredentialsProvider defaultCredentialsProvider;
        private MetricCollector metricCollector;

        private Builder() {
        }

        public SdkRequest request() {
            return this.request;
        }

        public Builder request(SdkRequest request) {
            this.request = request;
            return this;
        }

        public Signer defaultSigner() {
            return this.defaultSigner;
        }

        public Builder defaultSigner(Signer defaultSigner) {
            this.defaultSigner = defaultSigner;
            return this;
        }

        public AwsCredentialsProvider defaultCredentialsProvider() {
            return this.defaultCredentialsProvider;
        }

        public Builder defaultCredentialsProvider(AwsCredentialsProvider defaultCredentialsProvider) {
            this.defaultCredentialsProvider = defaultCredentialsProvider;
            return this;
        }

        public MetricCollector metricCollector() {
            return this.metricCollector;
        }

        public Builder metricCollector(MetricCollector metricCollector) {
            this.metricCollector = metricCollector;
            return this;
        }

        public AwsCredentialsAuthorizationStrategy build() {
            return new AwsCredentialsAuthorizationStrategy(this);
        }
    }
}

