/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.internal;

import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.signer.internal.util.SignerMethodResolver;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.AwsExecutionAttribute;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.client.config.AwsClientOption;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.internal.authcontext.AuthorizationStrategy;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.internal.authcontext.AuthorizationStrategyFactory;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.HttpChecksumConstant;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.RequestOverrideConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientOption;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.http.ExecutionContext;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.ExecutionInterceptorChain;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.InterceptorContext;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.InternalCoreExecutionAttribute;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.util.HttpChecksumResolver;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.signer.Signer;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.endpoints.EndpointProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.metrics.MetricCollector;

@SdkInternalApi
public final class AwsExecutionContextBuilder {
    private AwsExecutionContextBuilder() {
    }

    public static <InputT extends SdkRequest, OutputT extends SdkResponse> ExecutionContext invokeInterceptorsAndCreateExecutionContext(ClientExecutionParams<InputT, OutputT> executionParams, SdkClientConfiguration clientConfig) {
        InputT originalRequest = executionParams.getInput();
        MetricCollector metricCollector = AwsExecutionContextBuilder.resolveMetricCollector(executionParams);
        ExecutionAttributes executionAttributes = AwsExecutionContextBuilder.mergeExecutionAttributeOverrides(executionParams.executionAttributes(), clientConfig.option(SdkClientOption.EXECUTION_ATTRIBUTES), ((SdkRequest)originalRequest).overrideConfiguration().map(c -> c.executionAttributes()).orElse(null));
        executionAttributes.putAttribute(InternalCoreExecutionAttribute.EXECUTION_ATTEMPT, 1).putAttribute(AwsSignerExecutionAttribute.SERVICE_CONFIG, clientConfig.option(SdkClientOption.SERVICE_CONFIGURATION)).putAttribute(AwsSignerExecutionAttribute.SERVICE_SIGNING_NAME, clientConfig.option(AwsClientOption.SERVICE_SIGNING_NAME)).putAttribute(AwsExecutionAttribute.AWS_REGION, clientConfig.option(AwsClientOption.AWS_REGION)).putAttribute(AwsExecutionAttribute.ENDPOINT_PREFIX, clientConfig.option(AwsClientOption.ENDPOINT_PREFIX)).putAttribute(AwsSignerExecutionAttribute.SIGNING_REGION, clientConfig.option(AwsClientOption.SIGNING_REGION)).putAttribute(SdkInternalExecutionAttribute.IS_FULL_DUPLEX, executionParams.isFullDuplex()).putAttribute(SdkInternalExecutionAttribute.HAS_INITIAL_REQUEST_EVENT, executionParams.hasInitialRequestEvent()).putAttribute(SdkExecutionAttribute.CLIENT_TYPE, clientConfig.option(SdkClientOption.CLIENT_TYPE)).putAttribute(SdkExecutionAttribute.SERVICE_NAME, clientConfig.option(SdkClientOption.SERVICE_NAME)).putAttribute(SdkExecutionAttribute.PROFILE_FILE, clientConfig.option(SdkClientOption.PROFILE_FILE_SUPPLIER) != null ? clientConfig.option(SdkClientOption.PROFILE_FILE_SUPPLIER).get() : null).putAttribute(SdkExecutionAttribute.PROFILE_FILE_SUPPLIER, clientConfig.option(SdkClientOption.PROFILE_FILE_SUPPLIER)).putAttribute(SdkExecutionAttribute.PROFILE_NAME, clientConfig.option(SdkClientOption.PROFILE_NAME)).putAttribute(AwsExecutionAttribute.DUALSTACK_ENDPOINT_ENABLED, clientConfig.option(AwsClientOption.DUALSTACK_ENDPOINT_ENABLED)).putAttribute(AwsExecutionAttribute.FIPS_ENDPOINT_ENABLED, clientConfig.option(AwsClientOption.FIPS_ENDPOINT_ENABLED)).putAttribute(SdkExecutionAttribute.OPERATION_NAME, executionParams.getOperationName()).putAttribute(SdkExecutionAttribute.CLIENT_ENDPOINT, clientConfig.option(SdkClientOption.ENDPOINT)).putAttribute(SdkExecutionAttribute.ENDPOINT_OVERRIDDEN, clientConfig.option(SdkClientOption.ENDPOINT_OVERRIDDEN)).putAttribute(SdkInternalExecutionAttribute.ENDPOINT_PROVIDER, AwsExecutionContextBuilder.resolveEndpointProvider(originalRequest, clientConfig)).putAttribute(SdkInternalExecutionAttribute.CLIENT_CONTEXT_PARAMS, clientConfig.option(SdkClientOption.CLIENT_CONTEXT_PARAMS)).putAttribute(SdkInternalExecutionAttribute.DISABLE_HOST_PREFIX_INJECTION, clientConfig.option(SdkAdvancedClientOption.DISABLE_HOST_PREFIX_INJECTION)).putAttribute(SdkExecutionAttribute.SIGNER_OVERRIDDEN, clientConfig.option(SdkClientOption.SIGNER_OVERRIDDEN)).putAttribute(AwsExecutionAttribute.USE_GLOBAL_ENDPOINT, clientConfig.option(AwsClientOption.USE_GLOBAL_ENDPOINT)).putAttribute(SdkExecutionAttribute.RESOLVED_CHECKSUM_SPECS, HttpChecksumResolver.resolveChecksumSpecs(executionAttributes));
        ExecutionInterceptorChain executionInterceptorChain = new ExecutionInterceptorChain(clientConfig.option(SdkClientOption.EXECUTION_INTERCEPTORS));
        InterceptorContext interceptorContext = InterceptorContext.builder().request((SdkRequest)originalRequest).asyncRequestBody(executionParams.getAsyncRequestBody()).requestBody(executionParams.getRequestBody()).build();
        interceptorContext = AwsExecutionContextBuilder.runInitialInterceptors(interceptorContext, executionAttributes, executionInterceptorChain);
        Signer signer = null;
        if (AwsExecutionContextBuilder.isAuthenticatedRequest(executionAttributes)) {
            AuthorizationStrategyFactory authorizationStrategyFactory = new AuthorizationStrategyFactory(interceptorContext.request(), metricCollector, clientConfig);
            AuthorizationStrategy authorizationStrategy = authorizationStrategyFactory.strategyFor(executionParams.credentialType());
            authorizationStrategy.addCredentialsToExecutionAttributes(executionAttributes);
            signer = authorizationStrategy.resolveSigner();
        }
        executionAttributes.putAttribute(HttpChecksumConstant.SIGNING_METHOD, SignerMethodResolver.resolveSigningMethodUsed(signer, executionAttributes, executionAttributes.getOptionalAttribute(AwsSignerExecutionAttribute.AWS_CREDENTIALS).orElse(null)));
        return ExecutionContext.builder().interceptorChain(executionInterceptorChain).interceptorContext(interceptorContext).executionAttributes(executionAttributes).signer(signer).metricCollector(metricCollector).build();
    }

    public static AwsCredentialsProvider resolveCredentialsProvider(SdkRequest originalRequest, AwsCredentialsProvider defaultProvider) {
        return originalRequest.overrideConfiguration().filter(c -> c instanceof AwsRequestOverrideConfiguration).map(c -> (AwsRequestOverrideConfiguration)c).flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElse(defaultProvider);
    }

    public static Signer resolveSigner(SdkRequest request, Signer defaultSigner) {
        return request.overrideConfiguration().flatMap(RequestOverrideConfiguration::signer).orElse(defaultSigner);
    }

    public static InterceptorContext runInitialInterceptors(InterceptorContext interceptorContext, ExecutionAttributes executionAttributes, ExecutionInterceptorChain executionInterceptorChain) {
        executionInterceptorChain.beforeExecution(interceptorContext, executionAttributes);
        return executionInterceptorChain.modifyRequest(interceptorContext, executionAttributes);
    }

    private static <InputT extends SdkRequest, OutputT extends SdkResponse> ExecutionAttributes mergeExecutionAttributeOverrides(ExecutionAttributes executionAttributes, ExecutionAttributes clientOverrideExecutionAttributes, ExecutionAttributes requestOverrideExecutionAttributes) {
        executionAttributes.putAbsentAttributes(requestOverrideExecutionAttributes);
        executionAttributes.putAbsentAttributes(clientOverrideExecutionAttributes);
        return executionAttributes;
    }

    private static MetricCollector resolveMetricCollector(ClientExecutionParams<?, ?> params) {
        MetricCollector metricCollector = params.getMetricCollector();
        if (metricCollector == null) {
            metricCollector = MetricCollector.create("ApiCall");
        }
        return metricCollector;
    }

    private static boolean isAuthenticatedRequest(ExecutionAttributes executionAttributes) {
        return executionAttributes.getOptionalAttribute(SdkInternalExecutionAttribute.IS_NONE_AUTH_TYPE_REQUEST).orElse(true);
    }

    private static EndpointProvider resolveEndpointProvider(SdkRequest request, SdkClientConfiguration clientConfig) {
        return request.overrideConfiguration().flatMap(RequestOverrideConfiguration::endpointProvider).orElse(clientConfig.option(SdkClientOption.ENDPOINT_PROVIDER));
    }
}

