/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore;

import java.net.URI;
import java.util.Objects;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkPublicApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkServiceClientConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.endpoints.EndpointProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.Region;

@SdkPublicApi
public abstract class AwsServiceClientConfiguration
extends SdkServiceClientConfiguration {
    private final Region region;

    protected AwsServiceClientConfiguration(Builder builder) {
        super(builder);
        this.region = builder.region();
    }

    public Region region() {
        return this.region;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        AwsServiceClientConfiguration serviceClientConfiguration = (AwsServiceClientConfiguration)o;
        return Objects.equals(this.region, serviceClientConfiguration.region);
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + super.hashCode();
        result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
        return result;
    }

    protected static abstract class BuilderImpl
    implements Builder {
        protected ClientOverrideConfiguration overrideConfiguration;
        protected Region region;
        protected URI endpointOverride;
        protected EndpointProvider endpointProvider;

        protected BuilderImpl() {
        }

        protected BuilderImpl(AwsServiceClientConfiguration awsServiceClientConfiguration) {
            this.overrideConfiguration = awsServiceClientConfiguration.overrideConfiguration();
            this.region = awsServiceClientConfiguration.region();
            this.endpointOverride = awsServiceClientConfiguration.endpointOverride().orElse(null);
            this.endpointProvider = awsServiceClientConfiguration.endpointProvider().orElse(null);
        }

        @Override
        public final ClientOverrideConfiguration overrideConfiguration() {
            return this.overrideConfiguration;
        }

        @Override
        public final Region region() {
            return this.region;
        }

        @Override
        public final URI endpointOverride() {
            return this.endpointOverride;
        }

        @Override
        public final EndpointProvider endpointProvider() {
            return this.endpointProvider;
        }
    }

    public static interface Builder
    extends SdkServiceClientConfiguration.Builder {
        default public Region region() {
            throw new UnsupportedOperationException();
        }

        default public Builder region(Region region) {
            throw new UnsupportedOperationException();
        }

        @Override
        default public Builder overrideConfiguration(ClientOverrideConfiguration clientOverrideConfiguration) {
            throw new UnsupportedOperationException();
        }

        @Override
        default public Builder endpointOverride(URI endpointOverride) {
            throw new UnsupportedOperationException();
        }

        @Override
        default public Builder endpointProvider(EndpointProvider endpointProvider) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AwsServiceClientConfiguration build();
    }
}

