/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.token.signer.aws;

import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkPublicApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.signer.params.TokenSignerParams;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.token.credentials.SdkToken;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.token.signer.SdkTokenExecutionAttribute;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.CredentialType;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.signer.Signer;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.SdkHttpFullRequest;

@SdkPublicApi
public final class BearerTokenSigner
implements Signer {
    private static final String BEARER_LABEL = "Bearer";

    public static BearerTokenSigner create() {
        return new BearerTokenSigner();
    }

    @Override
    public CredentialType credentialType() {
        return CredentialType.TOKEN;
    }

    public SdkHttpFullRequest sign(SdkHttpFullRequest request, TokenSignerParams signerParams) {
        return this.doSign(request, signerParams);
    }

    @Override
    public SdkHttpFullRequest sign(SdkHttpFullRequest request, ExecutionAttributes executionAttributes) {
        SdkToken token = executionAttributes.getAttribute(SdkTokenExecutionAttribute.SDK_TOKEN);
        return this.doSign(request, TokenSignerParams.builder().token(token).build());
    }

    private SdkHttpFullRequest doSign(SdkHttpFullRequest request, TokenSignerParams signerParams) {
        return request.toBuilder().putHeader("Authorization", this.buildAuthorizationHeader(signerParams.token())).build();
    }

    private String buildAuthorizationHeader(SdkToken token) {
        return String.format("%s %s", BEARER_LABEL, token.token());
    }
}

