/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.signer.params;

import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkPublicApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.token.credentials.SdkToken;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.Validate;

@SdkPublicApi
public class TokenSignerParams {
    private final SdkToken token;

    TokenSignerParams(BuilderImpl<?> builder) {
        this.token = Validate.paramNotNull(((BuilderImpl)builder).token, "Signing token");
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public SdkToken token() {
        return this.token;
    }

    protected static class BuilderImpl<B extends Builder>
    implements Builder<B> {
        private SdkToken token;

        protected BuilderImpl() {
        }

        @Override
        public B token(SdkToken token) {
            this.token = token;
            return (B)this;
        }

        public void setToken(SdkToken token) {
            this.token(token);
        }

        @Override
        public TokenSignerParams build() {
            return new TokenSignerParams(this);
        }
    }

    public static interface Builder<B extends Builder> {
        public B token(SdkToken var1);

        public TokenSignerParams build();
    }
}

