/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkPublicApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkTestInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.AwsCredentials;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.internal.ProfileCredentialsUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.exception.SdkClientException;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.profiles.Profile;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.profiles.ProfileFile;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.profiles.ProfileFileSupplier;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.profiles.ProfileFileSystemSetting;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.IoUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.SdkAutoCloseable;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.ToString;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.builder.CopyableBuilder;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public final class ProfileCredentialsProvider
implements AwsCredentialsProvider,
SdkAutoCloseable,
ToCopyableBuilder<Builder, ProfileCredentialsProvider> {
    private volatile AwsCredentialsProvider credentialsProvider;
    private final RuntimeException loadException;
    private final Supplier<ProfileFile> profileFile;
    private volatile ProfileFile currentProfileFile;
    private final String profileName;
    private final Supplier<ProfileFile> defaultProfileFileLoader;
    private final Object credentialsProviderLock = new Object();

    private ProfileCredentialsProvider(BuilderImpl builder) {
        this.defaultProfileFileLoader = builder.defaultProfileFileLoader;
        RuntimeException thrownException = null;
        String selectedProfileName = null;
        Supplier selectedProfileSupplier = null;
        try {
            selectedProfileName = Optional.ofNullable(builder.profileName).orElseGet(ProfileFileSystemSetting.AWS_PROFILE::getStringValueOrThrow);
            selectedProfileSupplier = Optional.ofNullable(builder.profileFile).orElseGet(() -> builder.defaultProfileFileLoader);
        }
        catch (RuntimeException e) {
            thrownException = e;
        }
        this.loadException = thrownException;
        this.profileName = selectedProfileName;
        this.profileFile = selectedProfileSupplier;
    }

    public static ProfileCredentialsProvider create() {
        return ProfileCredentialsProvider.builder().build();
    }

    public static ProfileCredentialsProvider create(String profileName) {
        return ProfileCredentialsProvider.builder().profileName(profileName).build();
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AwsCredentials resolveCredentials() {
        if (this.loadException != null) {
            throw this.loadException;
        }
        ProfileFile cachedOrRefreshedProfileFile = this.refreshProfileFile();
        if (this.shouldUpdateCredentialsProvider(cachedOrRefreshedProfileFile)) {
            Object object = this.credentialsProviderLock;
            synchronized (object) {
                if (this.shouldUpdateCredentialsProvider(cachedOrRefreshedProfileFile)) {
                    this.currentProfileFile = cachedOrRefreshedProfileFile;
                    this.handleProfileFileReload(cachedOrRefreshedProfileFile);
                }
            }
        }
        return this.credentialsProvider.resolveCredentials();
    }

    private void handleProfileFileReload(ProfileFile profileFile) {
        this.credentialsProvider = this.createCredentialsProvider(profileFile, this.profileName);
    }

    private ProfileFile refreshProfileFile() {
        return this.profileFile.get();
    }

    private boolean shouldUpdateCredentialsProvider(ProfileFile profileFile) {
        return this.credentialsProvider == null || !Objects.equals(this.currentProfileFile, profileFile);
    }

    public String toString() {
        return ToString.builder("ProfileCredentialsProvider").add("profileName", this.profileName).add("profileFile", this.currentProfileFile).build();
    }

    @Override
    public void close() {
        IoUtils.closeIfCloseable(this.credentialsProvider, null);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    private AwsCredentialsProvider createCredentialsProvider(ProfileFile profileFile, String profileName) {
        return (AwsCredentialsProvider)profileFile.profile(profileName).flatMap(p -> new ProfileCredentialsUtils(profileFile, (Profile)p, profileFile::profile).credentialsProvider()).orElseThrow(() -> {
            String errorMessage = String.format("Profile file contained no credentials for profile '%s': %s", profileName, profileFile);
            return SdkClientException.builder().message(errorMessage).build();
        });
    }

    static final class BuilderImpl
    implements Builder {
        private Supplier<ProfileFile> profileFile;
        private String profileName;
        private Supplier<ProfileFile> defaultProfileFileLoader = ProfileFile::defaultProfileFile;

        BuilderImpl() {
        }

        BuilderImpl(ProfileCredentialsProvider provider) {
            this.profileName = provider.profileName;
            this.defaultProfileFileLoader = provider.defaultProfileFileLoader;
            this.profileFile = provider.profileFile;
        }

        @Override
        public Builder profileFile(ProfileFile profileFile) {
            return this.profileFile((Supplier<ProfileFile>)Optional.ofNullable(profileFile).map(ProfileFileSupplier::fixedProfileFile).orElse(null));
        }

        public void setProfileFile(ProfileFile profileFile) {
            this.profileFile(profileFile);
        }

        @Override
        public Builder profileFile(Consumer<ProfileFile.Builder> profileFile) {
            return this.profileFile(ProfileFile.builder().applyMutation(profileFile).build());
        }

        @Override
        public Builder profileFile(Supplier<ProfileFile> profileFileSupplier) {
            this.profileFile = profileFileSupplier;
            return this;
        }

        public void setProfileFile(Supplier<ProfileFile> supplier) {
            this.profileFile(supplier);
        }

        @Override
        public Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public void setProfileName(String profileName) {
            this.profileName(profileName);
        }

        @Override
        public ProfileCredentialsProvider build() {
            return new ProfileCredentialsProvider(this);
        }

        @SdkTestInternalApi
        Builder defaultProfileFileLoader(Supplier<ProfileFile> defaultProfileFileLoader) {
            this.defaultProfileFileLoader = defaultProfileFileLoader;
            return this;
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProfileCredentialsProvider> {
        public Builder profileFile(ProfileFile var1);

        public Builder profileFile(Consumer<ProfileFile.Builder> var1);

        public Builder profileFile(Supplier<ProfileFile> var1);

        public Builder profileName(String var1);

        @Override
        public ProfileCredentialsProvider build();
    }
}

