/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.org.apache.flink.connector.aws.util;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.kinesis.shaded.org.apache.flink.connector.aws.config.AWSConfigConstants;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.EnvironmentVariableCredentialsProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.SystemPropertyCredentialsProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.credentials.WebIdentityTokenFileCredentialsProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.Protocol;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.SdkHttpClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.SdkHttpConfigurationOption;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.apache.ApacheHttpClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.Http2Configuration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.profiles.ProfileFile;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.regions.Region;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.StsClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.StsClientBuilder;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.AttributeMap;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.SdkAutoCloseable;
import org.apache.flink.util.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class AWSGeneralUtil {
    private static final Logger LOG = LoggerFactory.getLogger(AWSGeneralUtil.class);
    private static final Duration CONNECTION_ACQUISITION_TIMEOUT = Duration.ofSeconds(60L);
    private static final int INITIAL_WINDOW_SIZE_BYTES = 524288;
    private static final Duration HEALTH_CHECK_PING_PERIOD = Duration.ofSeconds(60L);
    private static final int HTTP_CLIENT_MAX_CONCURRENCY = 10000;
    private static final Duration HTTP_CLIENT_READ_TIMEOUT = Duration.ofMinutes(6L);
    private static final Protocol HTTP_PROTOCOL = Protocol.HTTP2;
    private static final boolean TRUST_ALL_CERTIFICATES = false;
    private static final AttributeMap HTTP_CLIENT_DEFAULTS = AttributeMap.builder().put(SdkHttpConfigurationOption.MAX_CONNECTIONS, 10000).put(SdkHttpConfigurationOption.READ_TIMEOUT, HTTP_CLIENT_READ_TIMEOUT).put(SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES, false).put(SdkHttpConfigurationOption.PROTOCOL, HTTP_PROTOCOL).build();

    public static AWSConfigConstants.CredentialProvider getCredentialProviderType(Properties configProps, String configPrefix) {
        if (!configProps.containsKey(configPrefix)) {
            if (configProps.containsKey(AWSConfigConstants.accessKeyId(configPrefix)) && configProps.containsKey(AWSConfigConstants.secretKey(configPrefix))) {
                return AWSConfigConstants.CredentialProvider.BASIC;
            }
            return AWSConfigConstants.CredentialProvider.AUTO;
        }
        try {
            return AWSConfigConstants.CredentialProvider.valueOf(configProps.getProperty(configPrefix));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Invalid AWS Credential Provider Type %s.", configProps.getProperty(configPrefix)), e);
        }
    }

    public static AwsCredentialsProvider getCredentialsProvider(Map<String, ?> configProps) {
        Properties properties = new Properties();
        properties.putAll(configProps);
        return AWSGeneralUtil.getCredentialsProvider(properties);
    }

    public static AwsCredentialsProvider getCredentialsProvider(Properties configProps) {
        return AWSGeneralUtil.getCredentialsProvider(configProps, "aws.credentials.provider");
    }

    public static AwsCredentialsProvider getCredentialsProvider(Properties configProps, String configPrefix) {
        AWSConfigConstants.CredentialProvider credentialProviderType = AWSGeneralUtil.getCredentialProviderType(configProps, configPrefix);
        switch (credentialProviderType) {
            case ENV_VAR: {
                return EnvironmentVariableCredentialsProvider.create();
            }
            case SYS_PROP: {
                return SystemPropertyCredentialsProvider.create();
            }
            case CUSTOM: {
                return AWSGeneralUtil.getCustomCredentialProvider(configProps, AWSConfigConstants.customCredentialsProviderClass(configPrefix));
            }
            case PROFILE: {
                return AWSGeneralUtil.getProfileCredentialProvider(configProps, configPrefix);
            }
            case BASIC: {
                return () -> AwsBasicCredentials.create(configProps.getProperty(AWSConfigConstants.accessKeyId(configPrefix)), configProps.getProperty(AWSConfigConstants.secretKey(configPrefix)));
            }
            case ASSUME_ROLE: {
                return AWSGeneralUtil.getAssumeRoleCredentialProvider(configProps, configPrefix);
            }
            case WEB_IDENTITY_TOKEN: {
                return AWSGeneralUtil.getWebIdentityTokenFileCredentialsProvider(WebIdentityTokenFileCredentialsProvider.builder(), configProps, configPrefix);
            }
            case AUTO: {
                return DefaultCredentialsProvider.builder().build();
            }
        }
        throw new IllegalArgumentException("Credential provider not supported: " + (Object)((Object)credentialProviderType));
    }

    public static AwsCredentialsProvider getCustomCredentialProvider(Properties conf, String confKey) {
        String configuredClass = conf.getProperty(confKey);
        if (configuredClass == null) {
            throw new RuntimeException("No custom AWS credential provider class was provided with config key " + confKey);
        }
        try {
            Class<?> customLoaderCls = Class.forName(configuredClass);
            return (AwsCredentialsProvider)customLoaderCls.getDeclaredConstructor(Properties.class).newInstance(conf);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            LOG.error("Failed to find the specified custom AWS credentials provider {} {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            LOG.error("Failed to instantiate the specified custom AWS credentials provider {} {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    public static AwsCredentialsProvider getProfileCredentialProvider(Properties configProps, String configPrefix) {
        String profileName = configProps.getProperty(AWSConfigConstants.profileName(configPrefix), null);
        ProfileCredentialsProvider.Builder profileBuilder = ProfileCredentialsProvider.builder().profileName(profileName);
        Optional.ofNullable(configProps.getProperty(AWSConfigConstants.profilePath(configPrefix))).map(x$0 -> Paths.get(x$0, new String[0])).ifPresent(path -> profileBuilder.profileFile(ProfileFile.builder().type(ProfileFile.Type.CREDENTIALS).content((Path)path).build()));
        return profileBuilder.build();
    }

    private static AwsCredentialsProvider getAssumeRoleCredentialProvider(Properties configProps, String configPrefix) {
        StsClientBuilder stsClientBuilder = (StsClientBuilder)((StsClientBuilder)StsClient.builder().credentialsProvider(AWSGeneralUtil.getCredentialsProvider(configProps, AWSConfigConstants.roleCredentialsProvider(configPrefix)))).region(AWSGeneralUtil.getRegion(configProps));
        Optional.ofNullable(AWSGeneralUtil.getStsEndpoint(configProps)).ifPresent(stsClientBuilder::endpointOverride);
        return ((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().refreshRequest((AssumeRoleRequest)AssumeRoleRequest.builder().roleArn(configProps.getProperty(AWSConfigConstants.roleArn(configPrefix))).roleSessionName(configProps.getProperty(AWSConfigConstants.roleSessionName(configPrefix))).externalId(configProps.getProperty(AWSConfigConstants.externalId(configPrefix))).build()).stsClient((StsClient)stsClientBuilder.build())).build();
    }

    @VisibleForTesting
    static AwsCredentialsProvider getWebIdentityTokenFileCredentialsProvider(WebIdentityTokenFileCredentialsProvider.Builder webIdentityBuilder, Properties configProps, String configPrefix) {
        Optional.ofNullable(configProps.getProperty(AWSConfigConstants.roleArn(configPrefix))).ifPresent(webIdentityBuilder::roleArn);
        Optional.ofNullable(configProps.getProperty(AWSConfigConstants.roleSessionName(configPrefix))).ifPresent(webIdentityBuilder::roleSessionName);
        Optional.ofNullable(configProps.getProperty(AWSConfigConstants.webIdentityTokenFile(configPrefix))).map(x$0 -> Paths.get(x$0, new String[0])).ifPresent(webIdentityBuilder::webIdentityTokenFile);
        return webIdentityBuilder.build();
    }

    public static SdkAsyncHttpClient createAsyncHttpClient(Properties configProperties) {
        return AWSGeneralUtil.createAsyncHttpClient(configProperties, NettyNioAsyncHttpClient.builder());
    }

    public static SdkAsyncHttpClient createAsyncHttpClient(Properties configProperties, NettyNioAsyncHttpClient.Builder httpClientBuilder) {
        AttributeMap.Builder clientConfiguration = AttributeMap.builder().put(SdkHttpConfigurationOption.TCP_KEEPALIVE, true);
        Optional.ofNullable(configProperties.getProperty("aws.http-client.max-concurrency")).map(Integer::parseInt).ifPresent(integer -> clientConfiguration.put(SdkHttpConfigurationOption.MAX_CONNECTIONS, integer));
        Optional.ofNullable(configProperties.getProperty("aws.http-client.read-timeout")).map(Integer::parseInt).map(Duration::ofMillis).ifPresent(timeout -> clientConfiguration.put(SdkHttpConfigurationOption.READ_TIMEOUT, timeout));
        Optional.ofNullable(configProperties.getProperty("aws.trust.all.certificates")).map(Boolean::parseBoolean).ifPresent(bool -> clientConfiguration.put(SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES, bool));
        Optional.ofNullable(configProperties.getProperty("aws.http.protocol.version")).map(Protocol::valueOf).ifPresent(protocol -> clientConfiguration.put(SdkHttpConfigurationOption.PROTOCOL, protocol));
        return AWSGeneralUtil.createAsyncHttpClient(clientConfiguration.build(), httpClientBuilder);
    }

    public static SdkAsyncHttpClient createAsyncHttpClient(NettyNioAsyncHttpClient.Builder httpClientBuilder) {
        return AWSGeneralUtil.createAsyncHttpClient(AttributeMap.empty(), httpClientBuilder);
    }

    public static SdkAsyncHttpClient createAsyncHttpClient(AttributeMap config, NettyNioAsyncHttpClient.Builder httpClientBuilder) {
        httpClientBuilder.connectionAcquisitionTimeout(CONNECTION_ACQUISITION_TIMEOUT).http2Configuration((Http2Configuration)Http2Configuration.builder().healthCheckPingPeriod(HEALTH_CHECK_PING_PERIOD).initialWindowSize(524288).build());
        return httpClientBuilder.buildWithDefaults(config.merge(HTTP_CLIENT_DEFAULTS));
    }

    public static SdkHttpClient createSyncHttpClient(AttributeMap config, ApacheHttpClient.Builder httpClientBuilder) {
        httpClientBuilder.connectionAcquisitionTimeout(CONNECTION_ACQUISITION_TIMEOUT);
        return httpClientBuilder.buildWithDefaults(config.merge(HTTP_CLIENT_DEFAULTS));
    }

    public static Region getRegion(Properties configProps) {
        return Region.of(configProps.getProperty("aws.region"));
    }

    public static URI getStsEndpoint(Properties configProps) {
        return Optional.ofNullable(configProps.getProperty(AWSConfigConstants.AWS_ROLE_STS_ENDPOINT)).map(URI::create).orElse(null);
    }

    public static boolean isValidRegion(Region region) {
        return Pattern.matches("^[a-z]+-([a-z]+[-]{0,1}[a-z]+-([0-9]|global)|global)$", region.id());
    }

    public static void validateAwsConfiguration(Properties config) {
        if (config.containsKey("aws.credentials.provider")) {
            AWSGeneralUtil.validateCredentialProvider(config);
            AWSConfigConstants.CredentialProvider credentialsProviderType = AWSGeneralUtil.getCredentialProviderType(config, "aws.credentials.provider");
            if (!(credentialsProviderType != AWSConfigConstants.CredentialProvider.BASIC || config.containsKey(AWSConfigConstants.AWS_ACCESS_KEY_ID) && config.containsKey(AWSConfigConstants.AWS_SECRET_ACCESS_KEY))) {
                throw new IllegalArgumentException("Please set values for AWS Access Key ID ('" + AWSConfigConstants.AWS_ACCESS_KEY_ID + "') and Secret Key ('" + AWSConfigConstants.AWS_SECRET_ACCESS_KEY + "') when using the BASIC AWS credential provider type.");
            }
        }
        if (config.containsKey("aws.region") && !AWSGeneralUtil.isValidRegion(AWSGeneralUtil.getRegion(config))) {
            StringBuilder sb = new StringBuilder();
            for (Region region : Region.regions()) {
                sb.append(region).append(", ");
            }
            throw new IllegalArgumentException("Invalid AWS region set in config. Valid values are: " + sb.toString());
        }
    }

    public static void closeResources(SdkAutoCloseable ... resources) {
        RuntimeException exception = null;
        for (SdkAutoCloseable resource : resources) {
            if (resource == null) continue;
            try {
                resource.close();
            }
            catch (RuntimeException e) {
                exception = (RuntimeException)ExceptionUtils.firstOrSuppressed((Throwable)e, exception);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public static void validateAwsCredentials(Properties config) {
        AWSGeneralUtil.validateAwsConfiguration(config);
        AWSGeneralUtil.getCredentialsProvider(config).resolveCredentials();
    }

    private static void validateCredentialProvider(Properties config) {
        try {
            AWSGeneralUtil.getCredentialsProvider(config);
        }
        catch (IllegalArgumentException e) {
            StringBuilder sb = new StringBuilder();
            for (AWSConfigConstants.CredentialProvider type : AWSConfigConstants.CredentialProvider.values()) {
                sb.append(type.toString()).append(", ");
            }
            throw new IllegalArgumentException("Invalid AWS Credential Provider Type set in config. Valid values are: " + sb.toString());
        }
    }
}

