/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesisfirehose.model.transform;

import org.apache.flink.kinesis.shaded.com.amazonaws.SdkClientException;
import org.apache.flink.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.MarshallLocation;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.MarshallingInfo;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.MarshallingType;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.StructuredPojo;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesisfirehose.model.Serializer;

@SdkInternalApi
public class SerializerMarshaller {
    private static final MarshallingInfo<StructuredPojo> PARQUETSERDE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParquetSerDe").build();
    private static final MarshallingInfo<StructuredPojo> ORCSERDE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OrcSerDe").build();
    private static final SerializerMarshaller instance = new SerializerMarshaller();

    public static SerializerMarshaller getInstance() {
        return instance;
    }

    public void marshall(Serializer serializer, ProtocolMarshaller protocolMarshaller) {
        if (serializer == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(serializer.getParquetSerDe(), PARQUETSERDE_BINDING);
            protocolMarshaller.marshall(serializer.getOrcSerDe(), ORCSERDE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

