/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesisfirehose.model.transform;

import java.util.List;
import org.apache.flink.kinesis.shaded.com.amazonaws.SdkClientException;
import org.apache.flink.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.MarshallLocation;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.MarshallingInfo;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.MarshallingType;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesisfirehose.model.HttpEndpointRequestConfiguration;

@SdkInternalApi
public class HttpEndpointRequestConfigurationMarshaller {
    private static final MarshallingInfo<String> CONTENTENCODING_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContentEncoding").build();
    private static final MarshallingInfo<List> COMMONATTRIBUTES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CommonAttributes").build();
    private static final HttpEndpointRequestConfigurationMarshaller instance = new HttpEndpointRequestConfigurationMarshaller();

    public static HttpEndpointRequestConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(HttpEndpointRequestConfiguration httpEndpointRequestConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (httpEndpointRequestConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(httpEndpointRequestConfiguration.getContentEncoding(), CONTENTENCODING_BINDING);
            protocolMarshaller.marshall(httpEndpointRequestConfiguration.getCommonAttributes(), COMMONATTRIBUTES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

