/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.producer;

import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.flink.kinesis.shaded.com.amazonaws.auth.AWSCredentialsProvider;
import org.apache.flink.kinesis.shaded.com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.producer.protobuf.Config;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.producer.protobuf.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KinesisProducerConfiguration {
    private static final Logger log = LoggerFactory.getLogger(KinesisProducerConfiguration.class);
    private List<Config.AdditionalDimension> additionalDims = new ArrayList<Config.AdditionalDimension>();
    private AWSCredentialsProvider credentialsProvider = new DefaultAWSCredentialsProviderChain();
    private AWSCredentialsProvider metricsCredentialsProvider = null;
    private boolean aggregationEnabled = true;
    private long aggregationMaxCount = 0xFFFFFFFFL;
    private long aggregationMaxSize = 51200L;
    private String cloudwatchEndpoint = "";
    private long cloudwatchPort = 443L;
    private long collectionMaxCount = 500L;
    private long collectionMaxSize = 0x500000L;
    private long connectTimeout = 6000L;
    private long credentialsRefreshDelay = 5000L;
    private boolean enableCoreDumps = false;
    private boolean failIfThrottled = false;
    private String kinesisEndpoint = "";
    private long kinesisPort = 443L;
    private String logLevel = "info";
    private long maxConnections = 24L;
    private String metricsGranularity = "shard";
    private String metricsLevel = "detailed";
    private String metricsNamespace = "KinesisProducerLibrary";
    private long metricsUploadDelay = 60000L;
    private long minConnections = 1L;
    private String nativeExecutable = "";
    private long rateLimit = 150L;
    private long recordMaxBufferedTime = 100L;
    private long recordTtl = 30000L;
    private String region = "";
    private long requestTimeout = 6000L;
    private String tempDirectory = "";
    private boolean verifyCertificate = true;
    private ThreadingModel threadingModel = ThreadingModel.PER_REQUEST;
    private int threadPoolSize = 0;

    public void addAdditionalMetricsDimension(String key, String value, String granularity) {
        if (!Pattern.matches("global|stream|shard", granularity)) {
            throw new IllegalArgumentException("level must match the pattern global|stream|shard, got " + granularity);
        }
        this.additionalDims.add(Config.AdditionalDimension.newBuilder().setKey(key).setValue(value).setGranularity(granularity).build());
    }

    public AWSCredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public KinesisProducerConfiguration setCredentialsProvider(AWSCredentialsProvider credentialsProvider) {
        if (credentialsProvider == null) {
            throw new NullPointerException("credentialsProvider cannot be null");
        }
        this.credentialsProvider = credentialsProvider;
        return this;
    }

    public AWSCredentialsProvider getMetricsCredentialsProvider() {
        return this.metricsCredentialsProvider;
    }

    public KinesisProducerConfiguration setMetricsCredentialsProvider(AWSCredentialsProvider metricsCredentialsProvider) {
        this.metricsCredentialsProvider = metricsCredentialsProvider;
        return this;
    }

    public static KinesisProducerConfiguration fromPropertiesFile(String path) {
        log.info("Attempting to load config from file " + path);
        Properties props = new Properties();
        try (FileInputStream is = new FileInputStream(path);){
            props.load(is);
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading config from properties file", e);
        }
        return KinesisProducerConfiguration.fromProperties(props);
    }

    public static KinesisProducerConfiguration fromProperties(Properties props) {
        KinesisProducerConfiguration config = new KinesisProducerConfiguration();
        Enumeration<?> propNames = props.propertyNames();
        while (propNames.hasMoreElements()) {
            boolean found = false;
            String key = propNames.nextElement().toString();
            String value = props.getProperty(key);
            for (Method method : KinesisProducerConfiguration.class.getMethods()) {
                if (!method.getName().equals("set" + key)) continue;
                found = true;
                Class<?> type = method.getParameterTypes()[0];
                try {
                    if (type == Long.TYPE) {
                        method.invoke((Object)config, Long.valueOf(value));
                        continue;
                    }
                    if (type == Integer.TYPE) {
                        method.invoke((Object)config, Integer.valueOf(value));
                        continue;
                    }
                    if (type == Boolean.TYPE) {
                        method.invoke((Object)config, Boolean.valueOf(value));
                        continue;
                    }
                    if (type != String.class) continue;
                    method.invoke((Object)config, value);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("Error trying to set field %s with the value '%s'", key, value), e);
                }
            }
            if (found) continue;
            log.warn("Property " + key + " ignored as there is no corresponding set method in " + KinesisProducerConfiguration.class.getSimpleName());
        }
        return config;
    }

    protected Config.Configuration.Builder additionalConfigsToProtobuf(Config.Configuration.Builder builder) {
        return builder.addAllAdditionalMetricDims(this.additionalDims);
    }

    public boolean isAggregationEnabled() {
        return this.aggregationEnabled;
    }

    public long getAggregationMaxCount() {
        return this.aggregationMaxCount;
    }

    public long getAggregationMaxSize() {
        return this.aggregationMaxSize;
    }

    public String getCloudwatchEndpoint() {
        return this.cloudwatchEndpoint;
    }

    public long getCloudwatchPort() {
        return this.cloudwatchPort;
    }

    public long getCollectionMaxCount() {
        return this.collectionMaxCount;
    }

    public long getCollectionMaxSize() {
        return this.collectionMaxSize;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public long getCredentialsRefreshDelay() {
        return this.credentialsRefreshDelay;
    }

    public boolean isEnableCoreDumps() {
        return this.enableCoreDumps;
    }

    public boolean isFailIfThrottled() {
        return this.failIfThrottled;
    }

    public String getKinesisEndpoint() {
        return this.kinesisEndpoint;
    }

    public long getKinesisPort() {
        return this.kinesisPort;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public long getMaxConnections() {
        return this.maxConnections;
    }

    public String getMetricsGranularity() {
        return this.metricsGranularity;
    }

    public String getMetricsLevel() {
        return this.metricsLevel;
    }

    public String getMetricsNamespace() {
        return this.metricsNamespace;
    }

    public long getMetricsUploadDelay() {
        return this.metricsUploadDelay;
    }

    public long getMinConnections() {
        return this.minConnections;
    }

    public String getNativeExecutable() {
        return this.nativeExecutable;
    }

    public long getRateLimit() {
        return this.rateLimit;
    }

    public long getRecordMaxBufferedTime() {
        return this.recordMaxBufferedTime;
    }

    public long getRecordTtl() {
        return this.recordTtl;
    }

    public String getRegion() {
        return this.region;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public String getTempDirectory() {
        return this.tempDirectory;
    }

    public boolean isVerifyCertificate() {
        return this.verifyCertificate;
    }

    public ThreadingModel getThreadingModel() {
        return this.threadingModel;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public KinesisProducerConfiguration setAggregationEnabled(boolean val) {
        this.aggregationEnabled = val;
        return this;
    }

    public KinesisProducerConfiguration setAggregationMaxCount(long val) {
        if (val < 1L || val > Long.MAX_VALUE) {
            throw new IllegalArgumentException("aggregationMaxCount must be between 1 and 9223372036854775807, got " + val);
        }
        this.aggregationMaxCount = val;
        return this;
    }

    public KinesisProducerConfiguration setAggregationMaxSize(long val) {
        if (val < 64L || val > 0x100000L) {
            throw new IllegalArgumentException("aggregationMaxSize must be between 64 and 1048576, got " + val);
        }
        this.aggregationMaxSize = val;
        return this;
    }

    public KinesisProducerConfiguration setCloudwatchEndpoint(String val) {
        if (!Pattern.matches("^([A-Za-z0-9-\\.]+)?$", val)) {
            throw new IllegalArgumentException("cloudwatchEndpoint must match the pattern ^([A-Za-z0-9-\\.]+)?$, got " + val);
        }
        this.cloudwatchEndpoint = val;
        return this;
    }

    public KinesisProducerConfiguration setCloudwatchPort(long val) {
        if (val < 1L || val > 65535L) {
            throw new IllegalArgumentException("cloudwatchPort must be between 1 and 65535, got " + val);
        }
        this.cloudwatchPort = val;
        return this;
    }

    public KinesisProducerConfiguration setCollectionMaxCount(long val) {
        if (val < 1L || val > 500L) {
            throw new IllegalArgumentException("collectionMaxCount must be between 1 and 500, got " + val);
        }
        this.collectionMaxCount = val;
        return this;
    }

    public KinesisProducerConfiguration setCollectionMaxSize(long val) {
        if (val < 52224L || val > Long.MAX_VALUE) {
            throw new IllegalArgumentException("collectionMaxSize must be between 52224 and 9223372036854775807, got " + val);
        }
        this.collectionMaxSize = val;
        return this;
    }

    public KinesisProducerConfiguration setConnectTimeout(long val) {
        if (val < 100L || val > 300000L) {
            throw new IllegalArgumentException("connectTimeout must be between 100 and 300000, got " + val);
        }
        this.connectTimeout = val;
        return this;
    }

    public KinesisProducerConfiguration setCredentialsRefreshDelay(long val) {
        if (val < 1L || val > 300000L) {
            throw new IllegalArgumentException("credentialsRefreshDelay must be between 1 and 300000, got " + val);
        }
        this.credentialsRefreshDelay = val;
        return this;
    }

    public KinesisProducerConfiguration setEnableCoreDumps(boolean val) {
        this.enableCoreDumps = val;
        return this;
    }

    public KinesisProducerConfiguration setFailIfThrottled(boolean val) {
        this.failIfThrottled = val;
        return this;
    }

    public KinesisProducerConfiguration setKinesisEndpoint(String val) {
        if (!Pattern.matches("^([A-Za-z0-9-\\.]+)?$", val)) {
            throw new IllegalArgumentException("kinesisEndpoint must match the pattern ^([A-Za-z0-9-\\.]+)?$, got " + val);
        }
        this.kinesisEndpoint = val;
        return this;
    }

    public KinesisProducerConfiguration setKinesisPort(long val) {
        if (val < 1L || val > 65535L) {
            throw new IllegalArgumentException("kinesisPort must be between 1 and 65535, got " + val);
        }
        this.kinesisPort = val;
        return this;
    }

    public KinesisProducerConfiguration setLogLevel(String val) {
        if (!Pattern.matches("info|warning|error", val)) {
            throw new IllegalArgumentException("logLevel must match the pattern info|warning|error, got " + val);
        }
        this.logLevel = val;
        return this;
    }

    public KinesisProducerConfiguration setMaxConnections(long val) {
        if (val < 1L || val > 256L) {
            throw new IllegalArgumentException("maxConnections must be between 1 and 256, got " + val);
        }
        this.maxConnections = val;
        return this;
    }

    public KinesisProducerConfiguration setMetricsGranularity(String val) {
        if (!Pattern.matches("global|stream|shard", val)) {
            throw new IllegalArgumentException("metricsGranularity must match the pattern global|stream|shard, got " + val);
        }
        this.metricsGranularity = val;
        return this;
    }

    public KinesisProducerConfiguration setMetricsLevel(String val) {
        if (!Pattern.matches("none|summary|detailed", val)) {
            throw new IllegalArgumentException("metricsLevel must match the pattern none|summary|detailed, got " + val);
        }
        this.metricsLevel = val;
        return this;
    }

    public KinesisProducerConfiguration setMetricsNamespace(String val) {
        if (!Pattern.matches("(?!AWS/).{1,255}", val)) {
            throw new IllegalArgumentException("metricsNamespace must match the pattern (?!AWS/).{1,255}, got " + val);
        }
        this.metricsNamespace = val;
        return this;
    }

    public KinesisProducerConfiguration setMetricsUploadDelay(long val) {
        if (val < 1L || val > 60000L) {
            throw new IllegalArgumentException("metricsUploadDelay must be between 1 and 60000, got " + val);
        }
        this.metricsUploadDelay = val;
        return this;
    }

    public KinesisProducerConfiguration setMinConnections(long val) {
        if (val < 1L || val > 16L) {
            throw new IllegalArgumentException("minConnections must be between 1 and 16, got " + val);
        }
        this.minConnections = val;
        return this;
    }

    public KinesisProducerConfiguration setNativeExecutable(String val) {
        this.nativeExecutable = val;
        return this;
    }

    public KinesisProducerConfiguration setRateLimit(long val) {
        if (val < 1L || val > Long.MAX_VALUE) {
            throw new IllegalArgumentException("rateLimit must be between 1 and 9223372036854775807, got " + val);
        }
        this.rateLimit = val;
        return this;
    }

    public KinesisProducerConfiguration setRecordMaxBufferedTime(long val) {
        if (val < 0L || val > Long.MAX_VALUE) {
            throw new IllegalArgumentException("recordMaxBufferedTime must be between 0 and 9223372036854775807, got " + val);
        }
        this.recordMaxBufferedTime = val;
        return this;
    }

    public KinesisProducerConfiguration setRecordTtl(long val) {
        if (val < 100L || val > Long.MAX_VALUE) {
            throw new IllegalArgumentException("recordTtl must be between 100 and 9223372036854775807, got " + val);
        }
        this.recordTtl = val;
        return this;
    }

    public KinesisProducerConfiguration setRegion(String val) {
        if (!Pattern.matches("^([a-z]+-([a-z]+-)?[a-z]+-[0-9])?$", val)) {
            throw new IllegalArgumentException("region must match the pattern ^([a-z]+-([a-z]+-)?[a-z]+-[0-9])?$, got " + val);
        }
        this.region = val;
        return this;
    }

    public KinesisProducerConfiguration setRequestTimeout(long val) {
        if (val < 100L || val > 600000L) {
            throw new IllegalArgumentException("requestTimeout must be between 100 and 600000, got " + val);
        }
        this.requestTimeout = val;
        return this;
    }

    public KinesisProducerConfiguration setTempDirectory(String val) {
        this.tempDirectory = val;
        return this;
    }

    public KinesisProducerConfiguration setVerifyCertificate(boolean val) {
        this.verifyCertificate = val;
        return this;
    }

    public KinesisProducerConfiguration setThreadingModel(ThreadingModel threadingModel) {
        this.threadingModel = threadingModel;
        return this;
    }

    public KinesisProducerConfiguration setThreadingModel(String threadingModel) {
        return this.setThreadingModel(ThreadingModel.valueOf(threadingModel));
    }

    public KinesisProducerConfiguration setThreadPoolSize(int threadPoolSize) {
        if (threadPoolSize < 0) {
            throw new IllegalArgumentException("Max threads must greater than or equal to 0");
        }
        this.threadPoolSize = threadPoolSize;
        return this;
    }

    protected Messages.Message toProtobufMessage() {
        Config.Configuration.Builder builder = Config.Configuration.newBuilder().setAggregationEnabled(this.aggregationEnabled).setAggregationMaxCount(this.aggregationMaxCount).setAggregationMaxSize(this.aggregationMaxSize).setCloudwatchEndpoint(this.cloudwatchEndpoint).setCloudwatchPort(this.cloudwatchPort).setCollectionMaxCount(this.collectionMaxCount).setCollectionMaxSize(this.collectionMaxSize).setConnectTimeout(this.connectTimeout).setEnableCoreDumps(this.enableCoreDumps).setFailIfThrottled(this.failIfThrottled).setKinesisEndpoint(this.kinesisEndpoint).setKinesisPort(this.kinesisPort).setLogLevel(this.logLevel).setMaxConnections(this.maxConnections).setMetricsGranularity(this.metricsGranularity).setMetricsLevel(this.metricsLevel).setMetricsNamespace(this.metricsNamespace).setMetricsUploadDelay(this.metricsUploadDelay).setMinConnections(this.minConnections).setRateLimit(this.rateLimit).setRecordMaxBufferedTime(this.recordMaxBufferedTime).setRecordTtl(this.recordTtl).setRegion(this.region).setRequestTimeout(this.requestTimeout).setVerifyCertificate(this.verifyCertificate).setThreadConfig(this.threadingModel.threadConfig);
        if (this.threadPoolSize > 0) {
            builder = builder.setThreadPoolSize(this.threadPoolSize);
        }
        Config.Configuration c = this.additionalConfigsToProtobuf(builder).build();
        return Messages.Message.newBuilder().setConfiguration(c).setId(0L).build();
    }

    public static enum ThreadingModel {
        PER_REQUEST(Config.Configuration.ThreadConfig.PER_REQUEST),
        POOLED(Config.Configuration.ThreadConfig.POOLED);

        final Config.Configuration.ThreadConfig threadConfig;

        private ThreadingModel(Config.Configuration.ThreadConfig threadConfig) {
            this.threadConfig = threadConfig;
        }
    }
}

