/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.ITask;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStreamExtended;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.MetricsCollectingTaskDecorator;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardSyncTask;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardSyncer;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.TaskResult;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.proxies.IKinesisProxy;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.leases.impl.KinesisClientLease;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.leases.interfaces.ILeaseManager;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.metrics.interfaces.IMetricsFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.Shard;
import org.apache.flink.kinesis.shaded.org.apache.commons.logging.Log;
import org.apache.flink.kinesis.shaded.org.apache.commons.logging.LogFactory;

class ShardSyncTaskManager {
    private static final Log LOG = LogFactory.getLog(ShardSyncTaskManager.class);
    private ITask currentTask;
    private CompletableFuture<TaskResult> future;
    private final IKinesisProxy kinesisProxy;
    private final ILeaseManager<KinesisClientLease> leaseManager;
    private final IMetricsFactory metricsFactory;
    private final ExecutorService executorService;
    private final InitialPositionInStreamExtended initialPositionInStream;
    private boolean cleanupLeasesUponShardCompletion;
    private boolean ignoreUnexpectedChildShards;
    private final long shardSyncIdleTimeMillis;
    private final ShardSyncer shardSyncer;
    private final ReentrantLock lock;
    private AtomicBoolean shardSyncRequestPending;

    ShardSyncTaskManager(IKinesisProxy kinesisProxy, ILeaseManager<KinesisClientLease> leaseManager, InitialPositionInStreamExtended initialPositionInStream, boolean cleanupLeasesUponShardCompletion, boolean ignoreUnexpectedChildShards, long shardSyncIdleTimeMillis, IMetricsFactory metricsFactory, ExecutorService executorService, ShardSyncer shardSyncer) {
        this.kinesisProxy = kinesisProxy;
        this.leaseManager = leaseManager;
        this.metricsFactory = metricsFactory;
        this.cleanupLeasesUponShardCompletion = cleanupLeasesUponShardCompletion;
        this.ignoreUnexpectedChildShards = ignoreUnexpectedChildShards;
        this.shardSyncIdleTimeMillis = shardSyncIdleTimeMillis;
        this.executorService = executorService;
        this.initialPositionInStream = initialPositionInStream;
        this.shardSyncer = shardSyncer;
        this.shardSyncRequestPending = new AtomicBoolean(false);
        this.lock = new ReentrantLock();
    }

    Future<TaskResult> syncShardAndLeaseInfo(List<Shard> latestShards) {
        try {
            this.lock.lock();
            Future<TaskResult> future = this.checkAndSubmitNextTask(latestShards);
            return future;
        }
        finally {
            this.lock.unlock();
        }
    }

    private Future<TaskResult> checkAndSubmitNextTask(List<Shard> latestShards) {
        CompletableFuture<TaskResult> submittedTaskFuture = null;
        if (this.future == null || this.future.isCancelled() || this.future.isDone()) {
            if (this.future != null && this.future.isDone()) {
                try {
                    TaskResult result = this.future.get();
                    if (result.getException() != null) {
                        LOG.error("Caught exception running " + (Object)((Object)this.currentTask.getTaskType()) + " task: ", result.getException());
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.warn((Object)((Object)this.currentTask.getTaskType()) + " task encountered exception.", e);
                }
            }
            this.currentTask = new MetricsCollectingTaskDecorator(new ShardSyncTask(this.kinesisProxy, this.leaseManager, this.initialPositionInStream, this.cleanupLeasesUponShardCompletion, this.ignoreUnexpectedChildShards, this.shardSyncIdleTimeMillis, this.shardSyncer, latestShards), this.metricsFactory);
            this.future = CompletableFuture.supplyAsync(() -> this.currentTask.call(), this.executorService).whenComplete((taskResult, exception) -> this.handlePendingShardSyncs((Throwable)exception, (TaskResult)taskResult));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Submitted new " + (Object)((Object)this.currentTask.getTaskType()) + " task.");
            }
            submittedTaskFuture = this.future;
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Previous " + (Object)((Object)this.currentTask.getTaskType()) + " task still pending.  Not submitting new task. Enqueued a request that will be executed when the current request completes.");
            }
            this.shardSyncRequestPending.compareAndSet(false, true);
        }
        return submittedTaskFuture;
    }

    private void handlePendingShardSyncs(Throwable exception, TaskResult taskResult) {
        if (exception != null || taskResult.getException() != null) {
            LOG.error("Caught exception running " + (Object)((Object)this.currentTask.getTaskType()) + " task: ", exception != null ? exception : taskResult.getException());
        }
        try {
            this.lock.lock();
            if (this.shardSyncRequestPending.get()) {
                this.shardSyncRequestPending.set(false);
                this.future = null;
                this.checkAndSubmitNextTask(null);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public ITask getCurrentTask() {
        return this.currentTask;
    }

    public CompletableFuture<TaskResult> getFuture() {
        return this.future;
    }

    public IKinesisProxy getKinesisProxy() {
        return this.kinesisProxy;
    }

    public ILeaseManager<KinesisClientLease> getLeaseManager() {
        return this.leaseManager;
    }

    public IMetricsFactory getMetricsFactory() {
        return this.metricsFactory;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public InitialPositionInStreamExtended getInitialPositionInStream() {
        return this.initialPositionInStream;
    }

    public boolean isCleanupLeasesUponShardCompletion() {
        return this.cleanupLeasesUponShardCompletion;
    }

    public boolean isIgnoreUnexpectedChildShards() {
        return this.ignoreUnexpectedChildShards;
    }

    public long getShardSyncIdleTimeMillis() {
        return this.shardSyncIdleTimeMillis;
    }

    public ShardSyncer getShardSyncer() {
        return this.shardSyncer;
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    public AtomicBoolean getShardSyncRequestPending() {
        return this.shardSyncRequestPending;
    }
}

