/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.transform;

import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.S3BucketSource;
import org.apache.flink.kinesis.shaded.com.amazonaws.transform.JsonUnmarshallerContext;
import org.apache.flink.kinesis.shaded.com.amazonaws.transform.Unmarshaller;
import org.apache.flink.kinesis.shaded.com.fasterxml.jackson.core.JsonToken;

public class S3BucketSourceJsonUnmarshaller
implements Unmarshaller<S3BucketSource, JsonUnmarshallerContext> {
    private static S3BucketSourceJsonUnmarshaller instance;

    @Override
    public S3BucketSource unmarshall(JsonUnmarshallerContext context) throws Exception {
        S3BucketSource s3BucketSource = new S3BucketSource();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("S3BucketOwner", targetDepth)) {
                    context.nextToken();
                    s3BucketSource.setS3BucketOwner(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("S3Bucket", targetDepth)) {
                    context.nextToken();
                    s3BucketSource.setS3Bucket(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("S3KeyPrefix", targetDepth)) {
                    context.nextToken();
                    s3BucketSource.setS3KeyPrefix(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return s3BucketSource;
    }

    public static S3BucketSourceJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new S3BucketSourceJsonUnmarshaller();
        }
        return instance;
    }
}

